<?php
/**
 * This class stands for XLicensedResource EnumType
 * @subpackage Enumerations
 */
class XLicensedResource
{
    /**
     * Constant for value 'Tin'
     * @return string 'Tin'
     */
    const VALUE_TIN = 'Tin';
    /**
     * Constant for value 'Copper'
     * @return string 'Copper'
     */
    const VALUE_COPPER = 'Copper';
    /**
     * Constant for value 'Bronze'
     * @return string 'Bronze'
     */
    const VALUE_BRONZE = 'Bronze';
    /**
     * Constant for value 'Silver'
     * @return string 'Silver'
     */
    const VALUE_SILVER = 'Silver';
    /**
     * Constant for value 'Gold'
     * @return string 'Gold'
     */
    const VALUE_GOLD = 'Gold';
    /**
     * Constant for value 'Telepresence'
     * @return string 'Telepresence'
     */
    const VALUE_TELEPRESENCE = 'Telepresence';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TIN
     * @uses self::VALUE_COPPER
     * @uses self::VALUE_BRONZE
     * @uses self::VALUE_SILVER
     * @uses self::VALUE_GOLD
     * @uses self::VALUE_TELEPRESENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TIN,
            self::VALUE_COPPER,
            self::VALUE_BRONZE,
            self::VALUE_SILVER,
            self::VALUE_GOLD,
            self::VALUE_TELEPRESENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
