<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLicenseUnitReport StructType
 * @subpackage Structs
 */
class XLicenseUnitReport extends AbstractStructBase
{
    /**
     * The serverName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $serverName;
    /**
     * The phoneLicenseFeature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var PhoneLicenseFeature
     */
    public $phoneLicenseFeature;
    /**
     * The ccmNodeLicenseFeature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var CcmNodeLicenseFeature
     */
    public $ccmNodeLicenseFeature;
    /**
     * The softwareLicenseVersion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var SoftwareLicenseVersion
     */
    public $softwareLicenseVersion;
    /**
     * Constructor method for XLicenseUnitReport
     * @uses XLicenseUnitReport::setServerName()
     * @uses XLicenseUnitReport::setPhoneLicenseFeature()
     * @uses XLicenseUnitReport::setCcmNodeLicenseFeature()
     * @uses XLicenseUnitReport::setSoftwareLicenseVersion()
     * @param string $serverName
     * @param PhoneLicenseFeature $phoneLicenseFeature
     * @param CcmNodeLicenseFeature $ccmNodeLicenseFeature
     * @param SoftwareLicenseVersion $softwareLicenseVersion
     */
    public function __construct($serverName = null, PhoneLicenseFeature $phoneLicenseFeature = null, CcmNodeLicenseFeature $ccmNodeLicenseFeature = null, SoftwareLicenseVersion $softwareLicenseVersion = null)
    {
        $this
            ->setServerName($serverName)
            ->setPhoneLicenseFeature($phoneLicenseFeature)
            ->setCcmNodeLicenseFeature($ccmNodeLicenseFeature)
            ->setSoftwareLicenseVersion($softwareLicenseVersion);
    }
    /**
     * Get serverName value
     * @return string|null
     */
    public function getServerName()
    {
        return $this->serverName;
    }
    /**
     * Set serverName value
     * @param string $serverName
     * @return XLicenseUnitReport
     */
    public function setServerName($serverName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serverName) && strlen($serverName) > 255) || (is_array($serverName) && count($serverName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($serverName) ? strlen($serverName) : count($serverName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serverName) && !is_string($serverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverName)), __LINE__);
        }
        $this->serverName = $serverName;
        return $this;
    }
    /**
     * Get phoneLicenseFeature value
     * @return PhoneLicenseFeature|null
     */
    public function getPhoneLicenseFeature()
    {
        return $this->phoneLicenseFeature;
    }
    /**
     * Set phoneLicenseFeature value
     * @param PhoneLicenseFeature $phoneLicenseFeature
     * @return XLicenseUnitReport
     */
    public function setPhoneLicenseFeature(PhoneLicenseFeature $phoneLicenseFeature = null)
    {
        $this->phoneLicenseFeature = $phoneLicenseFeature;
        return $this;
    }
    /**
     * Get ccmNodeLicenseFeature value
     * @return CcmNodeLicenseFeature|null
     */
    public function getCcmNodeLicenseFeature()
    {
        return $this->ccmNodeLicenseFeature;
    }
    /**
     * Set ccmNodeLicenseFeature value
     * @param CcmNodeLicenseFeature $ccmNodeLicenseFeature
     * @return XLicenseUnitReport
     */
    public function setCcmNodeLicenseFeature(CcmNodeLicenseFeature $ccmNodeLicenseFeature = null)
    {
        $this->ccmNodeLicenseFeature = $ccmNodeLicenseFeature;
        return $this;
    }
    /**
     * Get softwareLicenseVersion value
     * @return SoftwareLicenseVersion|null
     */
    public function getSoftwareLicenseVersion()
    {
        return $this->softwareLicenseVersion;
    }
    /**
     * Set softwareLicenseVersion value
     * @param SoftwareLicenseVersion $softwareLicenseVersion
     * @return XLicenseUnitReport
     */
    public function setSoftwareLicenseVersion(SoftwareLicenseVersion $softwareLicenseVersion = null)
    {
        $this->softwareLicenseVersion = $softwareLicenseVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XLicenseUnitReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
