<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeEnrolledPatternGroup StructType
 * @subpackage Structs
 */
class XImeEnrolledPatternGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The fallbackProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $fallbackProfileName;
    /**
     * The isPatternAllAlias
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPatternAllAlias;
    /**
     * Constructor method for XImeEnrolledPatternGroup
     * @uses XImeEnrolledPatternGroup::setName()
     * @uses XImeEnrolledPatternGroup::setDescription()
     * @uses XImeEnrolledPatternGroup::setFallbackProfileName()
     * @uses XImeEnrolledPatternGroup::setIsPatternAllAlias()
     * @param string $name
     * @param string $description
     * @param XFkType $fallbackProfileName
     * @param string $isPatternAllAlias
     */
    public function __construct($name = null, $description = null, XFkType $fallbackProfileName = null, $isPatternAllAlias = false)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setFallbackProfileName($fallbackProfileName)
            ->setIsPatternAllAlias($isPatternAllAlias);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XImeEnrolledPatternGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XImeEnrolledPatternGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fallbackProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getFallbackProfileName()
    {
        return isset($this->fallbackProfileName) ? $this->fallbackProfileName : null;
    }
    /**
     * Set fallbackProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $fallbackProfileName
     * @return XImeEnrolledPatternGroup
     */
    public function setFallbackProfileName(XFkType $fallbackProfileName = null)
    {
        if (is_null($fallbackProfileName) || (is_array($fallbackProfileName) && empty($fallbackProfileName))) {
            unset($this->fallbackProfileName);
        } else {
            $this->fallbackProfileName = $fallbackProfileName;
        }
        return $this;
    }
    /**
     * Get isPatternAllAlias value
     * @return string|null
     */
    public function getIsPatternAllAlias()
    {
        return $this->isPatternAllAlias;
    }
    /**
     * Set isPatternAllAlias value
     * @param string $isPatternAllAlias
     * @return XImeEnrolledPatternGroup
     */
    public function setIsPatternAllAlias($isPatternAllAlias = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isPatternAllAlias) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPatternAllAlias, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPatternAllAlias) && !is_string($isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPatternAllAlias)), __LINE__);
        }
        $this->isPatternAllAlias = $isPatternAllAlias;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XImeEnrolledPatternGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
