<?php
/**
 * This class stands for XIPMALineMode EnumType
 * @subpackage Enumerations
 */
class XIPMALineMode
{
    /**
     * Constant for value 'Proxy'
     * @return string 'Proxy'
     */
    const VALUE_PROXY = 'Proxy';
    /**
     * Constant for value 'Shared'
     * @return string 'Shared'
     */
    const VALUE_SHARED = 'Shared';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PROXY
     * @uses self::VALUE_SHARED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PROXY,
            self::VALUE_SHARED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
