<?php
/**
 * This class stands for XILSSyncStatus EnumType
 * @subpackage Enumerations
 */
class XILSSyncStatus
{
    /**
     * Constant for value 'Up to date'
     * @return string 'Up to date'
     */
    const VALUE_UP_TO_DATE = 'Up to date';
    /**
     * Constant for value 'Disabled'
     * @return string 'Disabled'
     */
    const VALUE_DISABLED = 'Disabled';
    /**
     * Constant for value 'Requires sync'
     * @return string 'Requires sync'
     */
    const VALUE_REQUIRES_SYNC = 'Requires sync';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UP_TO_DATE
     * @uses self::VALUE_DISABLED
     * @uses self::VALUE_REQUIRES_SYNC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UP_TO_DATE,
            self::VALUE_DISABLED,
            self::VALUE_REQUIRES_SYNC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
