<?php
/**
 * This class stands for XE911Message EnumType
 * @subpackage Enumerations
 */
class XE911Message
{
    /**
     * Constant for value 'Agreement'
     * @return string 'Agreement'
     */
    const VALUE_AGREEMENT = 'Agreement';
    /**
     * Constant for value 'Disclaimer'
     * @return string 'Disclaimer'
     */
    const VALUE_DISCLAIMER = 'Disclaimer';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AGREEMENT
     * @uses self::VALUE_DISCLAIMER
     * @uses self::VALUE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AGREEMENT,
            self::VALUE_DISCLAIMER,
            self::VALUE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
