<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDirectoryUri StructType
 * @subpackage Structs
 */
class XDirectoryUri extends AbstractStructBase
{
    /**
     * The isPrimary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPrimary;
    /**
     * The uri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 128
     * @var string
     */
    public $uri;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $partition;
    /**
     * Constructor method for XDirectoryUri
     * @uses XDirectoryUri::setIsPrimary()
     * @uses XDirectoryUri::setUri()
     * @uses XDirectoryUri::setPartition()
     * @param string $isPrimary
     * @param string $uri
     * @param XFkType $partition
     */
    public function __construct($isPrimary = null, $uri = null, XFkType $partition = null)
    {
        $this
            ->setIsPrimary($isPrimary)
            ->setUri($uri)
            ->setPartition($partition);
    }
    /**
     * Get isPrimary value
     * @return string
     */
    public function getIsPrimary()
    {
        return $this->isPrimary;
    }
    /**
     * Set isPrimary value
     * @param string $isPrimary
     * @return XDirectoryUri
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isPrimary) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPrimary, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPrimary) && !is_string($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPrimary)), __LINE__);
        }
        $this->isPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get uri value
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return XDirectoryUri
     */
    public function setUri($uri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uri) && strlen($uri) > 128) || (is_array($uri) && count($uri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($uri) ? strlen($uri) : count($uri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Get partition value
     * @return XFkType
     */
    public function getPartition()
    {
        return $this->partition;
    }
    /**
     * Set partition value
     * @param XFkType $partition
     * @return XDirectoryUri
     */
    public function setPartition(XFkType $partition = null)
    {
        $this->partition = $partition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XDirectoryUri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
