<?php
/**
 * This class stands for XDeviceFeature EnumType
 * @subpackage Enumerations
 */
class XDeviceFeature
{
    /**
     * Constant for value 'Presence Status Report'
     * @return string 'Presence Status Report'
     */
    const VALUE_PRESENCE_STATUS_REPORT = 'Presence Status Report';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRESENCE_STATUS_REPORT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRESENCE_STATUS_REPORT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
