<?php
/**
 * This class stands for XDPWebProtocol EnumType
 * @subpackage Enumerations
 */
class XDPWebProtocol
{
    /**
     * Constant for value 'REST'
     * @return string 'REST'
     */
    const VALUE_REST = 'REST';
    /**
     * Constant for value 'SOAP'
     * @return string 'SOAP'
     */
    const VALUE_SOAP = 'SOAP';
    /**
     * Constant for value 'Not Applicable'
     * @return string 'Not Applicable'
     */
    const VALUE_NOT_APPLICABLE = 'Not Applicable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REST
     * @uses self::VALUE_SOAP
     * @uses self::VALUE_NOT_APPLICABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REST,
            self::VALUE_SOAP,
            self::VALUE_NOT_APPLICABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
