<?php
/**
 * This class stands for XCubaDevice EnumType
 * @subpackage Enumerations
 */
class XCubaDevice
{
    /**
     * Constant for value 'CUCMBE3000'
     * @return string 'CUCMBE3000'
     */
    const VALUE_CUCMBE_3000 = 'CUCMBE3000';
    /**
     * Constant for value 'ISR2901'
     * @return string 'ISR2901'
     */
    const VALUE_ISR_2901 = 'ISR2901';
    /**
     * Constant for value 'SPA8800'
     * @return string 'SPA8800'
     */
    const VALUE_SPA_8800 = 'SPA8800';
    /**
     * Constant for value 'BE3000'
     * @return string 'BE3000'
     */
    const VALUE_BE_3000 = 'BE3000';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CUCMBE_3000
     * @uses self::VALUE_ISR_2901
     * @uses self::VALUE_SPA_8800
     * @uses self::VALUE_BE_3000
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CUCMBE_3000,
            self::VALUE_ISR_2901,
            self::VALUE_SPA_8800,
            self::VALUE_BE_3000,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
