<?php
/**
 * This class stands for XChangeNotifySubscribe EnumType
 * @subpackage Enumerations
 */
class XChangeNotifySubscribe
{
    /**
     * Constant for value 'User'
     * @return string 'User'
     */
    const VALUE_USER = 'User';
    /**
     * Constant for value 'Line'
     * @return string 'Line'
     */
    const VALUE_LINE = 'Line';
    /**
     * Constant for value 'Phone'
     * @return string 'Phone'
     */
    const VALUE_PHONE = 'Phone';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USER
     * @uses self::VALUE_LINE
     * @uses self::VALUE_PHONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USER,
            self::VALUE_LINE,
            self::VALUE_PHONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
