<?php
/**
 * This class stands for XCertificate EnumType
 * @subpackage Enumerations
 */
class XCertificate
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'No Certificate Exists'
     * @return string 'No Certificate Exists'
     */
    const VALUE_NO_CERTIFICATE_EXISTS = 'No Certificate Exists';
    /**
     * Constant for value 'Locally Significant Certificate'
     * @return string 'Locally Significant Certificate'
     */
    const VALUE_LOCALLY_SIGNIFICANT_CERTIFICATE = 'Locally Significant Certificate';
    /**
     * Constant for value 'Manufacture Installed Certificate Exists'
     * @return string 'Manufacture Installed Certificate Exists'
     */
    const VALUE_MANUFACTURE_INSTALLED_CERTIFICATE_EXISTS = 'Manufacture Installed Certificate Exists';
    /**
     * Constant for value 'Locally Significant Certificate and Manufacture Installed
     * Certificate Exists'
     * @return string 'Locally Significant Certificate and Manufacture Installed Certificate Exists'
     */
    const VALUE_LOCALLY_SIGNIFICANT_CERTIFICATE_AND_MANUFACTURE_INSTALLED_CERTIFICATE_EXISTS = 'Locally Significant Certificate and Manufacture Installed Certificate Exists';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_NO_CERTIFICATE_EXISTS
     * @uses self::VALUE_LOCALLY_SIGNIFICANT_CERTIFICATE
     * @uses self::VALUE_MANUFACTURE_INSTALLED_CERTIFICATE_EXISTS
     * @uses self::VALUE_LOCALLY_SIGNIFICANT_CERTIFICATE_AND_MANUFACTURE_INSTALLED_CERTIFICATE_EXISTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_NO_CERTIFICATE_EXISTS,
            self::VALUE_LOCALLY_SIGNIFICANT_CERTIFICATE,
            self::VALUE_MANUFACTURE_INSTALLED_CERTIFICATE_EXISTS,
            self::VALUE_LOCALLY_SIGNIFICANT_CERTIFICATE_AND_MANUFACTURE_INSTALLED_CERTIFICATE_EXISTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
