<?php
/**
 * This class stands for XCallInfoDisplay EnumType
 * @subpackage Enumerations
 */
class XCallInfoDisplay
{
    /**
     * Constant for value 'Original Dialed Number'
     * @return string 'Original Dialed Number'
     */
    const VALUE_ORIGINAL_DIALED_NUMBER = 'Original Dialed Number';
    /**
     * Constant for value 'Redirected Dialed Number'
     * @return string 'Redirected Dialed Number'
     */
    const VALUE_REDIRECTED_DIALED_NUMBER = 'Redirected Dialed Number';
    /**
     * Constant for value 'Caller Number'
     * @return string 'Caller Number'
     */
    const VALUE_CALLER_NUMBER = 'Caller Number';
    /**
     * Constant for value 'Caller Name'
     * @return string 'Caller Name'
     */
    const VALUE_CALLER_NAME = 'Caller Name';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORIGINAL_DIALED_NUMBER
     * @uses self::VALUE_REDIRECTED_DIALED_NUMBER
     * @uses self::VALUE_CALLER_NUMBER
     * @uses self::VALUE_CALLER_NAME
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORIGINAL_DIALED_NUMBER,
            self::VALUE_REDIRECTED_DIALED_NUMBER,
            self::VALUE_CALLER_NUMBER,
            self::VALUE_CALLER_NAME,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
