<?php
/**
 * This class stands for XBATJobStatus EnumType
 * @subpackage Enumerations
 */
class XBATJobStatus
{
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Stop Requested'
     * @return string 'Stop Requested'
     */
    const VALUE_STOP_REQUESTED = 'Stop Requested';
    /**
     * Constant for value 'Processing'
     * @return string 'Processing'
     */
    const VALUE_PROCESSING = 'Processing';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'InComplete'
     * @return string 'InComplete'
     */
    const VALUE_IN_COMPLETE = 'InComplete';
    /**
     * Constant for value 'Hold'
     * @return string 'Hold'
     */
    const VALUE_HOLD = 'Hold';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_STOP_REQUESTED
     * @uses self::VALUE_PROCESSING
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_IN_COMPLETE
     * @uses self::VALUE_HOLD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_STOP_REQUESTED,
            self::VALUE_PROCESSING,
            self::VALUE_COMPLETED,
            self::VALUE_IN_COMPLETE,
            self::VALUE_HOLD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
