<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUserGroupReq StructType
 * @subpackage Structs
 */
class UpdateUserGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $newName;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The removeUserRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RemoveUserRoles
     */
    public $removeUserRoles;
    /**
     * The addUserRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddUserRoles
     */
    public $addUserRoles;
    /**
     * The userRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UserRoles
     */
    public $userRoles;
    /**
     * Constructor method for UpdateUserGroupReq
     * @uses UpdateUserGroupReq::setNewName()
     * @uses UpdateUserGroupReq::setRemoveMembers()
     * @uses UpdateUserGroupReq::setAddMembers()
     * @uses UpdateUserGroupReq::setMembers()
     * @uses UpdateUserGroupReq::setRemoveUserRoles()
     * @uses UpdateUserGroupReq::setAddUserRoles()
     * @uses UpdateUserGroupReq::setUserRoles()
     * @param string $newName
     * @param RemoveMembers $removeMembers
     * @param AddMembers $addMembers
     * @param Members $members
     * @param RemoveUserRoles $removeUserRoles
     * @param AddUserRoles $addUserRoles
     * @param UserRoles $userRoles
     */
    public function __construct($newName = null, RemoveMembers $removeMembers = null, AddMembers $addMembers = null, Members $members = null, RemoveUserRoles $removeUserRoles = null, AddUserRoles $addUserRoles = null, UserRoles $userRoles = null)
    {
        $this
            ->setNewName($newName)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setRemoveUserRoles($removeUserRoles)
            ->setAddUserRoles($addUserRoles)
            ->setUserRoles($userRoles);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateUserGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 128) || (is_array($newName) && count($newName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param RemoveMembers $removeMembers
     * @return UpdateUserGroupReq
     */
    public function setRemoveMembers(RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param AddMembers $addMembers
     * @return UpdateUserGroupReq
     */
    public function setAddMembers(AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return UpdateUserGroupReq
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get removeUserRoles value
     * @return RemoveUserRoles|null
     */
    public function getRemoveUserRoles()
    {
        return $this->removeUserRoles;
    }
    /**
     * Set removeUserRoles value
     * @param RemoveUserRoles $removeUserRoles
     * @return UpdateUserGroupReq
     */
    public function setRemoveUserRoles(RemoveUserRoles $removeUserRoles = null)
    {
        $this->removeUserRoles = $removeUserRoles;
        return $this;
    }
    /**
     * Get addUserRoles value
     * @return AddUserRoles|null
     */
    public function getAddUserRoles()
    {
        return $this->addUserRoles;
    }
    /**
     * Set addUserRoles value
     * @param AddUserRoles $addUserRoles
     * @return UpdateUserGroupReq
     */
    public function setAddUserRoles(AddUserRoles $addUserRoles = null)
    {
        $this->addUserRoles = $addUserRoles;
        return $this;
    }
    /**
     * Get userRoles value
     * @return UserRoles|null
     */
    public function getUserRoles()
    {
        return $this->userRoles;
    }
    /**
     * Set userRoles value
     * @param UserRoles $userRoles
     * @return UpdateUserGroupReq
     */
    public function setUserRoles(UserRoles $userRoles = null)
    {
        $this->userRoles = $userRoles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateUserGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
