<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSIPNormalizationScriptReq StructType
 * @subpackage Structs
 */
class UpdateSIPNormalizationScriptReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $content;
    /**
     * The scriptExecutionErrorRecoveryAction
     * Meta informations extracted from the WSDL
     * - default: Message Rollback Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scriptExecutionErrorRecoveryAction;
    /**
     * The systemResourceErrorRecoveryAction
     * Meta informations extracted from the WSDL
     * - default: Disable Script
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $systemResourceErrorRecoveryAction;
    /**
     * The maxMemoryThreshold
     * Meta informations extracted from the WSDL
     * - default: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxMemoryThreshold;
    /**
     * The maxLuaInstructionsThreshold
     * Meta informations extracted from the WSDL
     * - default: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxLuaInstructionsThreshold;
    /**
     * Constructor method for UpdateSIPNormalizationScriptReq
     * @uses UpdateSIPNormalizationScriptReq::setNewName()
     * @uses UpdateSIPNormalizationScriptReq::setDescription()
     * @uses UpdateSIPNormalizationScriptReq::setContent()
     * @uses UpdateSIPNormalizationScriptReq::setScriptExecutionErrorRecoveryAction()
     * @uses UpdateSIPNormalizationScriptReq::setSystemResourceErrorRecoveryAction()
     * @uses UpdateSIPNormalizationScriptReq::setMaxMemoryThreshold()
     * @uses UpdateSIPNormalizationScriptReq::setMaxLuaInstructionsThreshold()
     * @param string $newName
     * @param string $description
     * @param string $content
     * @param string $scriptExecutionErrorRecoveryAction
     * @param string $systemResourceErrorRecoveryAction
     * @param string $maxMemoryThreshold
     * @param string $maxLuaInstructionsThreshold
     */
    public function __construct($newName = null, $description = null, $content = null, $scriptExecutionErrorRecoveryAction = 'Message Rollback Only', $systemResourceErrorRecoveryAction = 'Disable Script', $maxMemoryThreshold = '50', $maxLuaInstructionsThreshold = '1000')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setContent($content)
            ->setScriptExecutionErrorRecoveryAction($scriptExecutionErrorRecoveryAction)
            ->setSystemResourceErrorRecoveryAction($systemResourceErrorRecoveryAction)
            ->setMaxMemoryThreshold($maxMemoryThreshold)
            ->setMaxLuaInstructionsThreshold($maxLuaInstructionsThreshold);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateSIPNormalizationScriptReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateSIPNormalizationScriptReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return UpdateSIPNormalizationScriptReq
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get scriptExecutionErrorRecoveryAction value
     * @return string|null
     */
    public function getScriptExecutionErrorRecoveryAction()
    {
        return $this->scriptExecutionErrorRecoveryAction;
    }
    /**
     * Set scriptExecutionErrorRecoveryAction value
     * @uses XSIPScriptErrorHandling::valueIsValid()
     * @uses XSIPScriptErrorHandling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scriptExecutionErrorRecoveryAction
     * @return UpdateSIPNormalizationScriptReq
     */
    public function setScriptExecutionErrorRecoveryAction($scriptExecutionErrorRecoveryAction = 'Message Rollback Only')
    {
        // validation for constraint: enumeration
        if (!XSIPScriptErrorHandling::valueIsValid($scriptExecutionErrorRecoveryAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scriptExecutionErrorRecoveryAction, implode(', ', XSIPScriptErrorHandling::getValidValues())), __LINE__);
        }
        $this->scriptExecutionErrorRecoveryAction = $scriptExecutionErrorRecoveryAction;
        return $this;
    }
    /**
     * Get systemResourceErrorRecoveryAction value
     * @return string|null
     */
    public function getSystemResourceErrorRecoveryAction()
    {
        return $this->systemResourceErrorRecoveryAction;
    }
    /**
     * Set systemResourceErrorRecoveryAction value
     * @uses XSIPScriptErrorHandling::valueIsValid()
     * @uses XSIPScriptErrorHandling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $systemResourceErrorRecoveryAction
     * @return UpdateSIPNormalizationScriptReq
     */
    public function setSystemResourceErrorRecoveryAction($systemResourceErrorRecoveryAction = 'Disable Script')
    {
        // validation for constraint: enumeration
        if (!XSIPScriptErrorHandling::valueIsValid($systemResourceErrorRecoveryAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $systemResourceErrorRecoveryAction, implode(', ', XSIPScriptErrorHandling::getValidValues())), __LINE__);
        }
        $this->systemResourceErrorRecoveryAction = $systemResourceErrorRecoveryAction;
        return $this;
    }
    /**
     * Get maxMemoryThreshold value
     * @return string|null
     */
    public function getMaxMemoryThreshold()
    {
        return $this->maxMemoryThreshold;
    }
    /**
     * Set maxMemoryThreshold value
     * @param string $maxMemoryThreshold
     * @return UpdateSIPNormalizationScriptReq
     */
    public function setMaxMemoryThreshold($maxMemoryThreshold = '50')
    {
        // validation for constraint: string
        if (!is_null($maxMemoryThreshold) && !is_string($maxMemoryThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxMemoryThreshold)), __LINE__);
        }
        $this->maxMemoryThreshold = $maxMemoryThreshold;
        return $this;
    }
    /**
     * Get maxLuaInstructionsThreshold value
     * @return string|null
     */
    public function getMaxLuaInstructionsThreshold()
    {
        return $this->maxLuaInstructionsThreshold;
    }
    /**
     * Set maxLuaInstructionsThreshold value
     * @param string $maxLuaInstructionsThreshold
     * @return UpdateSIPNormalizationScriptReq
     */
    public function setMaxLuaInstructionsThreshold($maxLuaInstructionsThreshold = '1000')
    {
        // validation for constraint: string
        if (!is_null($maxLuaInstructionsThreshold) && !is_string($maxLuaInstructionsThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxLuaInstructionsThreshold)), __LINE__);
        }
        $this->maxLuaInstructionsThreshold = $maxLuaInstructionsThreshold;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateSIPNormalizationScriptReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
