<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRegionMatrixReq StructType
 * @subpackage Structs
 */
class UpdateRegionMatrixReq extends APIRequest
{
    /**
     * The regionAName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $regionAName;
    /**
     * The regionBName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $regionBName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The bandwidth
     * Meta informations extracted from the WSDL
     * - documentation: The new bandwidth value for this particular region relationship.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $videoBandwidth;
    /**
     * The lossyNetwork
     * Meta informations extracted from the WSDL
     * - documentation: This tag has been deprecated in 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lossyNetwork;
    /**
     * The codecPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $codecPreference;
    /**
     * Constructor method for UpdateRegionMatrixReq
     * @uses UpdateRegionMatrixReq::setRegionAName()
     * @uses UpdateRegionMatrixReq::setRegionBName()
     * @uses UpdateRegionMatrixReq::setUuid()
     * @uses UpdateRegionMatrixReq::setBandwidth()
     * @uses UpdateRegionMatrixReq::setVideoBandwidth()
     * @uses UpdateRegionMatrixReq::setLossyNetwork()
     * @uses UpdateRegionMatrixReq::setCodecPreference()
     * @param XFkType $regionAName
     * @param XFkType $regionBName
     * @param string $uuid
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param string $lossyNetwork
     * @param XFkType $codecPreference
     */
    public function __construct(XFkType $regionAName = null, XFkType $regionBName = null, $uuid = null, $bandwidth = null, $videoBandwidth = '384', $lossyNetwork = null, XFkType $codecPreference = null)
    {
        $this
            ->setRegionAName($regionAName)
            ->setRegionBName($regionBName)
            ->setUuid($uuid)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setLossyNetwork($lossyNetwork)
            ->setCodecPreference($codecPreference);
    }
    /**
     * Get regionAName value
     * @return XFkType
     */
    public function getRegionAName()
    {
        return $this->regionAName;
    }
    /**
     * Set regionAName value
     * @param XFkType $regionAName
     * @return UpdateRegionMatrixReq
     */
    public function setRegionAName(XFkType $regionAName = null)
    {
        $this->regionAName = $regionAName;
        return $this;
    }
    /**
     * Get regionBName value
     * @return XFkType
     */
    public function getRegionBName()
    {
        return $this->regionBName;
    }
    /**
     * Set regionBName value
     * @param XFkType $regionBName
     * @return UpdateRegionMatrixReq
     */
    public function setRegionBName(XFkType $regionBName = null)
    {
        $this->regionBName = $regionBName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return UpdateRegionMatrixReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @uses XBandwidth::valueIsValid()
     * @uses XBandwidth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bandwidth
     * @return UpdateRegionMatrixReq
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: enumeration
        if (!XBandwidth::valueIsValid($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bandwidth, implode(', ', XBandwidth::getValidValues())), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return UpdateRegionMatrixReq
     */
    public function setVideoBandwidth($videoBandwidth = '384')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get lossyNetwork value
     * @return string|null
     */
    public function getLossyNetwork()
    {
        return $this->lossyNetwork;
    }
    /**
     * Set lossyNetwork value
     * @uses XLossyNetwork::valueIsValid()
     * @uses XLossyNetwork::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lossyNetwork
     * @return UpdateRegionMatrixReq
     */
    public function setLossyNetwork($lossyNetwork = null)
    {
        // validation for constraint: enumeration
        if (!XLossyNetwork::valueIsValid($lossyNetwork)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lossyNetwork, implode(', ', XLossyNetwork::getValidValues())), __LINE__);
        }
        $this->lossyNetwork = $lossyNetwork;
        return $this;
    }
    /**
     * Get codecPreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCodecPreference()
    {
        return isset($this->codecPreference) ? $this->codecPreference : null;
    }
    /**
     * Set codecPreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $codecPreference
     * @return UpdateRegionMatrixReq
     */
    public function setCodecPreference(XFkType $codecPreference = null)
    {
        if (is_null($codecPreference) || (is_array($codecPreference) && empty($codecPreference))) {
            unset($this->codecPreference);
        } else {
            $this->codecPreference = $codecPreference;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateRegionMatrixReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
