<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLocationReq StructType
 * @subpackage Structs
 */
class UpdateLocationReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The kbits
     * Meta informations extracted from the WSDL
     * - documentation: Deprecated from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kbits;
    /**
     * The videoKbits
     * Meta informations extracted from the WSDL
     * - documentation: Deprecated from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoKbits;
    /**
     * The relatedLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RelatedLocations
     */
    public $relatedLocations;
    /**
     * The withinAudioBandwidth
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $withinAudioBandwidth;
    /**
     * The withinVideoBandwidth
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $withinVideoBandwidth;
    /**
     * The withinImmersiveKbits
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $withinImmersiveKbits;
    /**
     * The betweenLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var BetweenLocations
     */
    public $betweenLocations;
    /**
     * Constructor method for UpdateLocationReq
     * @uses UpdateLocationReq::setNewName()
     * @uses UpdateLocationReq::setKbits()
     * @uses UpdateLocationReq::setVideoKbits()
     * @uses UpdateLocationReq::setRelatedLocations()
     * @uses UpdateLocationReq::setWithinAudioBandwidth()
     * @uses UpdateLocationReq::setWithinVideoBandwidth()
     * @uses UpdateLocationReq::setWithinImmersiveKbits()
     * @uses UpdateLocationReq::setBetweenLocations()
     * @param string $newName
     * @param string $kbits
     * @param string $videoKbits
     * @param RelatedLocations $relatedLocations
     * @param string $withinAudioBandwidth
     * @param string $withinVideoBandwidth
     * @param string $withinImmersiveKbits
     * @param BetweenLocations $betweenLocations
     */
    public function __construct($newName = null, $kbits = null, $videoKbits = null, RelatedLocations $relatedLocations = null, $withinAudioBandwidth = '0', $withinVideoBandwidth = '0', $withinImmersiveKbits = '0', BetweenLocations $betweenLocations = null)
    {
        $this
            ->setNewName($newName)
            ->setKbits($kbits)
            ->setVideoKbits($videoKbits)
            ->setRelatedLocations($relatedLocations)
            ->setWithinAudioBandwidth($withinAudioBandwidth)
            ->setWithinVideoBandwidth($withinVideoBandwidth)
            ->setWithinImmersiveKbits($withinImmersiveKbits)
            ->setBetweenLocations($betweenLocations);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateLocationReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get kbits value
     * @return string|null
     */
    public function getKbits()
    {
        return $this->kbits;
    }
    /**
     * Set kbits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kbits
     * @return UpdateLocationReq
     */
    public function setKbits($kbits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($kbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $kbits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->kbits = $kbits;
        return $this;
    }
    /**
     * Get videoKbits value
     * @return string|null
     */
    public function getVideoKbits()
    {
        return $this->videoKbits;
    }
    /**
     * Set videoKbits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoKbits
     * @return UpdateLocationReq
     */
    public function setVideoKbits($videoKbits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($videoKbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoKbits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->videoKbits = $videoKbits;
        return $this;
    }
    /**
     * Get relatedLocations value
     * @return RelatedLocations|null
     */
    public function getRelatedLocations()
    {
        return $this->relatedLocations;
    }
    /**
     * Set relatedLocations value
     * @param RelatedLocations $relatedLocations
     * @return UpdateLocationReq
     */
    public function setRelatedLocations(RelatedLocations $relatedLocations = null)
    {
        $this->relatedLocations = $relatedLocations;
        return $this;
    }
    /**
     * Get withinAudioBandwidth value
     * @return string|null
     */
    public function getWithinAudioBandwidth()
    {
        return $this->withinAudioBandwidth;
    }
    /**
     * Set withinAudioBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinAudioBandwidth
     * @return UpdateLocationReq
     */
    public function setWithinAudioBandwidth($withinAudioBandwidth = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinAudioBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinAudioBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinAudioBandwidth = $withinAudioBandwidth;
        return $this;
    }
    /**
     * Get withinVideoBandwidth value
     * @return string|null
     */
    public function getWithinVideoBandwidth()
    {
        return $this->withinVideoBandwidth;
    }
    /**
     * Set withinVideoBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinVideoBandwidth
     * @return UpdateLocationReq
     */
    public function setWithinVideoBandwidth($withinVideoBandwidth = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinVideoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinVideoBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinVideoBandwidth = $withinVideoBandwidth;
        return $this;
    }
    /**
     * Get withinImmersiveKbits value
     * @return string|null
     */
    public function getWithinImmersiveKbits()
    {
        return $this->withinImmersiveKbits;
    }
    /**
     * Set withinImmersiveKbits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinImmersiveKbits
     * @return UpdateLocationReq
     */
    public function setWithinImmersiveKbits($withinImmersiveKbits = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($withinImmersiveKbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $withinImmersiveKbits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->withinImmersiveKbits = $withinImmersiveKbits;
        return $this;
    }
    /**
     * Get betweenLocations value
     * @return BetweenLocations|null
     */
    public function getBetweenLocations()
    {
        return $this->betweenLocations;
    }
    /**
     * Set betweenLocations value
     * @param BetweenLocations $betweenLocations
     * @return UpdateLocationReq
     */
    public function setBetweenLocations(BetweenLocations $betweenLocations = null)
    {
        $this->betweenLocations = $betweenLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateLocationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
