<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCommonPhoneConfigReq StructType
 * @subpackage Structs
 */
class UpdateCommonPhoneConfigReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The unlockPwd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $unlockPwd;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The dndAlertingType
     * Meta informations extracted from the WSDL
     * - default: Beep Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndAlertingType;
    /**
     * The backgroundImage
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $backgroundImage;
    /**
     * The phonePersonalization
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phonePersonalization;
    /**
     * The phoneServiceDisplay
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The sshUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $sshUserId;
    /**
     * The sshPwd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $sshPwd;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The vpnGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $vpnGroupName;
    /**
     * The vpnProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $vpnProfileName;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $featureControlPolicy;
    /**
     * Constructor method for UpdateCommonPhoneConfigReq
     * @uses UpdateCommonPhoneConfigReq::setNewName()
     * @uses UpdateCommonPhoneConfigReq::setDescription()
     * @uses UpdateCommonPhoneConfigReq::setUnlockPwd()
     * @uses UpdateCommonPhoneConfigReq::setDndOption()
     * @uses UpdateCommonPhoneConfigReq::setDndAlertingType()
     * @uses UpdateCommonPhoneConfigReq::setBackgroundImage()
     * @uses UpdateCommonPhoneConfigReq::setPhonePersonalization()
     * @uses UpdateCommonPhoneConfigReq::setPhoneServiceDisplay()
     * @uses UpdateCommonPhoneConfigReq::setSshUserId()
     * @uses UpdateCommonPhoneConfigReq::setSshPwd()
     * @uses UpdateCommonPhoneConfigReq::setVendorConfig()
     * @uses UpdateCommonPhoneConfigReq::setAlwaysUsePrimeLine()
     * @uses UpdateCommonPhoneConfigReq::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses UpdateCommonPhoneConfigReq::setVpnGroupName()
     * @uses UpdateCommonPhoneConfigReq::setVpnProfileName()
     * @uses UpdateCommonPhoneConfigReq::setFeatureControlPolicy()
     * @param string $newName
     * @param string $description
     * @param string $unlockPwd
     * @param string $dndOption
     * @param string $dndAlertingType
     * @param string $backgroundImage
     * @param string $phonePersonalization
     * @param string $phoneServiceDisplay
     * @param string $sshUserId
     * @param string $sshPwd
     * @param XVendorConfig $vendorConfig
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param XFkType $vpnGroupName
     * @param XFkType $vpnProfileName
     * @param XFkType $featureControlPolicy
     */
    public function __construct($newName = null, $description = null, $unlockPwd = null, $dndOption = 'Ringer Off', $dndAlertingType = 'Beep Only', $backgroundImage = true, $phonePersonalization = 'Default', $phoneServiceDisplay = 'Default', $sshUserId = null, $sshPwd = null, XVendorConfig $vendorConfig = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', XFkType $vpnGroupName = null, XFkType $vpnProfileName = null, XFkType $featureControlPolicy = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setUnlockPwd($unlockPwd)
            ->setDndOption($dndOption)
            ->setDndAlertingType($dndAlertingType)
            ->setBackgroundImage($backgroundImage)
            ->setPhonePersonalization($phonePersonalization)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setSshUserId($sshUserId)
            ->setSshPwd($sshPwd)
            ->setVendorConfig($vendorConfig)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setVpnGroupName($vpnGroupName)
            ->setVpnProfileName($vpnProfileName)
            ->setFeatureControlPolicy($featureControlPolicy);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return UpdateCommonPhoneConfigReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateCommonPhoneConfigReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get unlockPwd value
     * @return string|null
     */
    public function getUnlockPwd()
    {
        return $this->unlockPwd;
    }
    /**
     * Set unlockPwd value
     * @param string $unlockPwd
     * @return UpdateCommonPhoneConfigReq
     */
    public function setUnlockPwd($unlockPwd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unlockPwd) && strlen($unlockPwd) > 50) || (is_array($unlockPwd) && count($unlockPwd) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($unlockPwd) ? strlen($unlockPwd) : count($unlockPwd)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unlockPwd) && !is_string($unlockPwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unlockPwd)), __LINE__);
        }
        $this->unlockPwd = $unlockPwd;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses XDNDOption::valueIsValid()
     * @uses XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return UpdateCommonPhoneConfigReq
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        // validation for constraint: enumeration
        if (!XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndAlertingType value
     * @return string|null
     */
    public function getDndAlertingType()
    {
        return $this->dndAlertingType;
    }
    /**
     * Set dndAlertingType value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndAlertingType
     * @return UpdateCommonPhoneConfigReq
     */
    public function setDndAlertingType($dndAlertingType = 'Beep Only')
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($dndAlertingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndAlertingType, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndAlertingType = $dndAlertingType;
        return $this;
    }
    /**
     * Get backgroundImage value
     * @return string|null
     */
    public function getBackgroundImage()
    {
        return $this->backgroundImage;
    }
    /**
     * Set backgroundImage value
     * @param string $backgroundImage
     * @return UpdateCommonPhoneConfigReq
     */
    public function setBackgroundImage($backgroundImage = true)
    {
        // validation for constraint: pattern
        if (is_scalar($backgroundImage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $backgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($backgroundImage, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($backgroundImage) && !is_string($backgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($backgroundImage)), __LINE__);
        }
        $this->backgroundImage = $backgroundImage;
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string|null
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @uses XPhonePersonalization::valueIsValid()
     * @uses XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phonePersonalization
     * @return UpdateCommonPhoneConfigReq
     */
    public function setPhonePersonalization($phonePersonalization = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPhonePersonalization::valueIsValid($phonePersonalization)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phonePersonalization, implode(', ', XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @uses XPhoneServiceDisplay::valueIsValid()
     * @uses XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneServiceDisplay
     * @return UpdateCommonPhoneConfigReq
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = 'Default')
    {
        // validation for constraint: enumeration
        if (!XPhoneServiceDisplay::valueIsValid($phoneServiceDisplay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneServiceDisplay, implode(', ', XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return UpdateCommonPhoneConfigReq
     */
    public function setSshUserId($sshUserId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sshUserId) && strlen($sshUserId) > 50) || (is_array($sshUserId) && count($sshUserId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($sshUserId) ? strlen($sshUserId) : count($sshUserId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sshUserId) && !is_string($sshUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sshUserId)), __LINE__);
        }
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get sshPwd value
     * @return string|null
     */
    public function getSshPwd()
    {
        return $this->sshPwd;
    }
    /**
     * Set sshPwd value
     * @param string $sshPwd
     * @return UpdateCommonPhoneConfigReq
     */
    public function setSshPwd($sshPwd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sshPwd) && strlen($sshPwd) > 255) || (is_array($sshPwd) && count($sshPwd) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($sshPwd) ? strlen($sshPwd) : count($sshPwd)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sshPwd) && !is_string($sshPwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sshPwd)), __LINE__);
        }
        $this->sshPwd = $sshPwd;
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XVendorConfig $vendorConfig
     * @return UpdateCommonPhoneConfigReq
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return UpdateCommonPhoneConfigReq
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return UpdateCommonPhoneConfigReq
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get vpnGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getVpnGroupName()
    {
        return isset($this->vpnGroupName) ? $this->vpnGroupName : null;
    }
    /**
     * Set vpnGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $vpnGroupName
     * @return UpdateCommonPhoneConfigReq
     */
    public function setVpnGroupName(XFkType $vpnGroupName = null)
    {
        if (is_null($vpnGroupName) || (is_array($vpnGroupName) && empty($vpnGroupName))) {
            unset($this->vpnGroupName);
        } else {
            $this->vpnGroupName = $vpnGroupName;
        }
        return $this;
    }
    /**
     * Get vpnProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getVpnProfileName()
    {
        return isset($this->vpnProfileName) ? $this->vpnProfileName : null;
    }
    /**
     * Set vpnProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $vpnProfileName
     * @return UpdateCommonPhoneConfigReq
     */
    public function setVpnProfileName(XFkType $vpnProfileName = null)
    {
        if (is_null($vpnProfileName) || (is_array($vpnProfileName) && empty($vpnProfileName))) {
            unset($this->vpnProfileName);
        } else {
            $this->vpnProfileName = $vpnProfileName;
        }
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return isset($this->featureControlPolicy) ? $this->featureControlPolicy : null;
    }
    /**
     * Set featureControlPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $featureControlPolicy
     * @return UpdateCommonPhoneConfigReq
     */
    public function setFeatureControlPolicy(XFkType $featureControlPolicy = null)
    {
        if (is_null($featureControlPolicy) || (is_array($featureControlPolicy) && empty($featureControlPolicy))) {
            unset($this->featureControlPolicy);
        } else {
            $this->featureControlPolicy = $featureControlPolicy;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateCommonPhoneConfigReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
