<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RNormalizationScriptInfo StructType
 * @subpackage Structs
 */
class RNormalizationScriptInfo extends AbstractStructBase
{
    /**
     * The parameterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $parameterName;
    /**
     * The parameterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $parameterValue;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RNormalizationScriptInfo
     * @uses RNormalizationScriptInfo::setParameterName()
     * @uses RNormalizationScriptInfo::setParameterValue()
     * @uses RNormalizationScriptInfo::setUuid()
     * @param string $parameterName
     * @param string $parameterValue
     * @param string $uuid
     */
    public function __construct($parameterName = null, $parameterValue = null, $uuid = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setParameterValue($parameterValue)
            ->setUuid($uuid);
    }
    /**
     * Get parameterName value
     * @return string|null
     */
    public function getParameterName()
    {
        return $this->parameterName;
    }
    /**
     * Set parameterName value
     * @param string $parameterName
     * @return RNormalizationScriptInfo
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parameterName) && strlen($parameterName) > 128) || (is_array($parameterName) && count($parameterName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($parameterName) ? strlen($parameterName) : count($parameterName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterName)), __LINE__);
        }
        $this->parameterName = $parameterName;
        return $this;
    }
    /**
     * Get parameterValue value
     * @return string|null
     */
    public function getParameterValue()
    {
        return $this->parameterValue;
    }
    /**
     * Set parameterValue value
     * @param string $parameterValue
     * @return RNormalizationScriptInfo
     */
    public function setParameterValue($parameterValue = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parameterValue) && strlen($parameterValue) > 128) || (is_array($parameterValue) && count($parameterValue) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($parameterValue) ? strlen($parameterValue) : count($parameterValue)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parameterValue) && !is_string($parameterValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parameterValue)), __LINE__);
        }
        $this->parameterValue = $parameterValue;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RNormalizationScriptInfo
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RNormalizationScriptInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
