<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RGatewayEndpointDigitalBri StructType
 * @subpackage Structs
 */
class RGatewayEndpointDigitalBri extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The redirectInboundNumberIe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The briProtocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $briProtocol;
    /**
     * The calledPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPlan;
    /**
     * The calledPri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPri;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPlan;
    /**
     * The callingPri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPri;
    /**
     * The clockReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clockReference;
    /**
     * The csuParam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csuParam;
    /**
     * The dChannelEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dChannelEnable;
    /**
     * The channelSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $channelSelectionOrder;
    /**
     * The pcmType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pcmType;
    /**
     * The firstDelay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstDelay;
    /**
     * The intraDelay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $intraDelay;
    /**
     * The redirectOutboundNumberIe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The numDigitsToStrip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numDigitsToStrip;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefix;
    /**
     * The presentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $presentationBit;
    /**
     * The sendRestart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRestart;
    /**
     * The setupNonIsdnPi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $setupNonIsdnPi;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var SigDigits
     */
    public $sigDigits;
    /**
     * The statusPoll
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $statusPoll;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * The nationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The nationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $nationalTransformationCssName;
    /**
     * The internationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $internationalTransformationCssName;
    /**
     * The unknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $unknownTransformationCssName;
    /**
     * The subscriberTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $subscriberTransformationCssName;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The GClearEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $GClearEnable;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RGatewayEndpointDigitalBri
     * @uses RGatewayEndpointDigitalBri::setIndex()
     * @uses RGatewayEndpointDigitalBri::setName()
     * @uses RGatewayEndpointDigitalBri::setDescription()
     * @uses RGatewayEndpointDigitalBri::setProduct()
     * @uses RGatewayEndpointDigitalBri::setModel()
     * @uses RGatewayEndpointDigitalBri::setClass()
     * @uses RGatewayEndpointDigitalBri::setProtocol()
     * @uses RGatewayEndpointDigitalBri::setProtocolSide()
     * @uses RGatewayEndpointDigitalBri::setCallingSearchSpaceName()
     * @uses RGatewayEndpointDigitalBri::setDevicePoolName()
     * @uses RGatewayEndpointDigitalBri::setCommonDeviceConfigName()
     * @uses RGatewayEndpointDigitalBri::setNetworkLocation()
     * @uses RGatewayEndpointDigitalBri::setLocationName()
     * @uses RGatewayEndpointDigitalBri::setMediaResourceListName()
     * @uses RGatewayEndpointDigitalBri::setNetworkLocale()
     * @uses RGatewayEndpointDigitalBri::setAutomatedAlternateRoutingCssName()
     * @uses RGatewayEndpointDigitalBri::setAarNeighborhoodName()
     * @uses RGatewayEndpointDigitalBri::setVendorConfig()
     * @uses RGatewayEndpointDigitalBri::setCgpnTransformationCssName()
     * @uses RGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCss()
     * @uses RGatewayEndpointDigitalBri::setGeoLocationName()
     * @uses RGatewayEndpointDigitalBri::setRedirectInboundNumberIe()
     * @uses RGatewayEndpointDigitalBri::setBriProtocol()
     * @uses RGatewayEndpointDigitalBri::setCalledPlan()
     * @uses RGatewayEndpointDigitalBri::setCalledPri()
     * @uses RGatewayEndpointDigitalBri::setCallerIdDn()
     * @uses RGatewayEndpointDigitalBri::setCallingPartySelection()
     * @uses RGatewayEndpointDigitalBri::setCallingPlan()
     * @uses RGatewayEndpointDigitalBri::setCallingPri()
     * @uses RGatewayEndpointDigitalBri::setClockReference()
     * @uses RGatewayEndpointDigitalBri::setCsuParam()
     * @uses RGatewayEndpointDigitalBri::setDChannelEnable()
     * @uses RGatewayEndpointDigitalBri::setChannelSelectionOrder()
     * @uses RGatewayEndpointDigitalBri::setPcmType()
     * @uses RGatewayEndpointDigitalBri::setFirstDelay()
     * @uses RGatewayEndpointDigitalBri::setIntraDelay()
     * @uses RGatewayEndpointDigitalBri::setRedirectOutboundNumberIe()
     * @uses RGatewayEndpointDigitalBri::setNumDigitsToStrip()
     * @uses RGatewayEndpointDigitalBri::setPrefix()
     * @uses RGatewayEndpointDigitalBri::setPresentationBit()
     * @uses RGatewayEndpointDigitalBri::setSendRestart()
     * @uses RGatewayEndpointDigitalBri::setSetupNonIsdnPi()
     * @uses RGatewayEndpointDigitalBri::setSigDigits()
     * @uses RGatewayEndpointDigitalBri::setStatusPoll()
     * @uses RGatewayEndpointDigitalBri::setPacketCaptureMode()
     * @uses RGatewayEndpointDigitalBri::setPacketCaptureDuration()
     * @uses RGatewayEndpointDigitalBri::setCdpnTransformationCssName()
     * @uses RGatewayEndpointDigitalBri::setUseDevicePoolCdpnTransformCss()
     * @uses RGatewayEndpointDigitalBri::setGeoLocationFilterName()
     * @uses RGatewayEndpointDigitalBri::setNationalPrefix()
     * @uses RGatewayEndpointDigitalBri::setInternationalPrefix()
     * @uses RGatewayEndpointDigitalBri::setUnknownPrefix()
     * @uses RGatewayEndpointDigitalBri::setSubscriberPrefix()
     * @uses RGatewayEndpointDigitalBri::setNationalStripDigits()
     * @uses RGatewayEndpointDigitalBri::setInternationalStripDigits()
     * @uses RGatewayEndpointDigitalBri::setUnknownStripDigits()
     * @uses RGatewayEndpointDigitalBri::setSubscriberStripDigits()
     * @uses RGatewayEndpointDigitalBri::setNationalTransformationCssName()
     * @uses RGatewayEndpointDigitalBri::setInternationalTransformationCssName()
     * @uses RGatewayEndpointDigitalBri::setUnknownTransformationCssName()
     * @uses RGatewayEndpointDigitalBri::setSubscriberTransformationCssName()
     * @uses RGatewayEndpointDigitalBri::setPstnAccess()
     * @uses RGatewayEndpointDigitalBri::setImeE164TransformationName()
     * @uses RGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssNatl()
     * @uses RGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssIntl()
     * @uses RGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses RGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssSubs()
     * @uses RGatewayEndpointDigitalBri::setGClearEnable()
     * @uses RGatewayEndpointDigitalBri::setCtiid()
     * @uses RGatewayEndpointDigitalBri::setUuid()
     * @param string $index
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $devicePoolName
     * @param XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param XFkType $locationName
     * @param XFkType $mediaResourceListName
     * @param string $networkLocale
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param XVendorConfig $vendorConfig
     * @param XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param XFkType $geoLocationName
     * @param string $redirectInboundNumberIe
     * @param string $briProtocol
     * @param string $calledPlan
     * @param string $calledPri
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingPlan
     * @param string $callingPri
     * @param string $clockReference
     * @param string $csuParam
     * @param string $dChannelEnable
     * @param string $channelSelectionOrder
     * @param string $pcmType
     * @param string $firstDelay
     * @param string $intraDelay
     * @param string $redirectOutboundNumberIe
     * @param string $numDigitsToStrip
     * @param string $prefix
     * @param string $presentationBit
     * @param string $sendRestart
     * @param string $setupNonIsdnPi
     * @param SigDigits $sigDigits
     * @param string $statusPoll
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param XFkType $geoLocationFilterName
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param XFkType $nationalTransformationCssName
     * @param XFkType $internationalTransformationCssName
     * @param XFkType $unknownTransformationCssName
     * @param XFkType $subscriberTransformationCssName
     * @param string $pstnAccess
     * @param XFkType $imeE164TransformationName
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $gClearEnable
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, XFkType $callingSearchSpaceName = null, XFkType $devicePoolName = null, XFkType $commonDeviceConfigName = null, $networkLocation = null, XFkType $locationName = null, XFkType $mediaResourceListName = null, $networkLocale = null, XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, XVendorConfig $vendorConfig = null, XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, XFkType $geoLocationName = null, $redirectInboundNumberIe = null, $briProtocol = null, $calledPlan = null, $calledPri = null, $callerIdDn = null, $callingPartySelection = null, $callingPlan = null, $callingPri = null, $clockReference = null, $csuParam = null, $dChannelEnable = null, $channelSelectionOrder = null, $pcmType = null, $firstDelay = null, $intraDelay = null, $redirectOutboundNumberIe = null, $numDigitsToStrip = null, $prefix = null, $presentationBit = null, $sendRestart = null, $setupNonIsdnPi = null, SigDigits $sigDigits = null, $statusPoll = null, $packetCaptureMode = null, $packetCaptureDuration = null, XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, XFkType $geoLocationFilterName = null, $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, XFkType $nationalTransformationCssName = null, XFkType $internationalTransformationCssName = null, XFkType $unknownTransformationCssName = null, XFkType $subscriberTransformationCssName = null, $pstnAccess = null, XFkType $imeE164TransformationName = null, $useDevicePoolCgpnTransformCssNatl = null, $useDevicePoolCgpnTransformCssIntl = null, $useDevicePoolCgpnTransformCssUnkn = null, $useDevicePoolCgpnTransformCssSubs = null, $gClearEnable = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkLocale($networkLocale)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setVendorConfig($vendorConfig)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setBriProtocol($briProtocol)
            ->setCalledPlan($calledPlan)
            ->setCalledPri($calledPri)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingPlan($callingPlan)
            ->setCallingPri($callingPri)
            ->setClockReference($clockReference)
            ->setCsuParam($csuParam)
            ->setDChannelEnable($dChannelEnable)
            ->setChannelSelectionOrder($channelSelectionOrder)
            ->setPcmType($pcmType)
            ->setFirstDelay($firstDelay)
            ->setIntraDelay($intraDelay)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setNumDigitsToStrip($numDigitsToStrip)
            ->setPrefix($prefix)
            ->setPresentationBit($presentationBit)
            ->setSendRestart($sendRestart)
            ->setSetupNonIsdnPi($setupNonIsdnPi)
            ->setSigDigits($sigDigits)
            ->setStatusPoll($statusPoll)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalTransformationCssName($nationalTransformationCssName)
            ->setInternationalTransformationCssName($internationalTransformationCssName)
            ->setUnknownTransformationCssName($unknownTransformationCssName)
            ->setSubscriberTransformationCssName($subscriberTransformationCssName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setGClearEnable($gClearEnable)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return RGatewayEndpointDigitalBri
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RGatewayEndpointDigitalBri
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RGatewayEndpointDigitalBri
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return RGatewayEndpointDigitalBri
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses XModel::valueIsValid()
     * @uses XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return RGatewayEndpointDigitalBri
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return RGatewayEndpointDigitalBri
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return RGatewayEndpointDigitalBri
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return RGatewayEndpointDigitalBri
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return RGatewayEndpointDigitalBri
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return RGatewayEndpointDigitalBri
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param XFkType $commonDeviceConfigName
     * @return RGatewayEndpointDigitalBri
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses XNetworkLocation::valueIsValid()
     * @uses XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return RGatewayEndpointDigitalBri
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return RGatewayEndpointDigitalBri
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param XFkType $mediaResourceListName
     * @return RGatewayEndpointDigitalBri
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return RGatewayEndpointDigitalBri
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param XFkType $automatedAlternateRoutingCssName
     * @return RGatewayEndpointDigitalBri
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param XFkType $aarNeighborhoodName
     * @return RGatewayEndpointDigitalBri
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return RGatewayEndpointDigitalBri
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param XFkType $cgpnTransformationCssName
     * @return RGatewayEndpointDigitalBri
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return RGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param XFkType $geoLocationName
     * @return RGatewayEndpointDigitalBri
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return RGatewayEndpointDigitalBri
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectInboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectInboundNumberIe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectInboundNumberIe) && !is_string($redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectInboundNumberIe)), __LINE__);
        }
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get briProtocol value
     * @return string|null
     */
    public function getBriProtocol()
    {
        return $this->briProtocol;
    }
    /**
     * Set briProtocol value
     * @uses XBriProtocol::valueIsValid()
     * @uses XBriProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $briProtocol
     * @return RGatewayEndpointDigitalBri
     */
    public function setBriProtocol($briProtocol = null)
    {
        // validation for constraint: enumeration
        if (!XBriProtocol::valueIsValid($briProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $briProtocol, implode(', ', XBriProtocol::getValidValues())), __LINE__);
        }
        $this->briProtocol = $briProtocol;
        return $this;
    }
    /**
     * Get calledPlan value
     * @return string|null
     */
    public function getCalledPlan()
    {
        return $this->calledPlan;
    }
    /**
     * Set calledPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPlan
     * @return RGatewayEndpointDigitalBri
     */
    public function setCalledPlan($calledPlan = null)
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($calledPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPlan = $calledPlan;
        return $this;
    }
    /**
     * Get calledPri value
     * @return string|null
     */
    public function getCalledPri()
    {
        return $this->calledPri;
    }
    /**
     * Set calledPri value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPri
     * @return RGatewayEndpointDigitalBri
     */
    public function setCalledPri($calledPri = null)
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($calledPri)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPri, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPri = $calledPri;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return RGatewayEndpointDigitalBri
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 255) || (is_array($callerIdDn) && count($callerIdDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses XCallingPartySelection::valueIsValid()
     * @uses XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return RGatewayEndpointDigitalBri
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingPlan value
     * @return string|null
     */
    public function getCallingPlan()
    {
        return $this->callingPlan;
    }
    /**
     * Set callingPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPlan
     * @return RGatewayEndpointDigitalBri
     */
    public function setCallingPlan($callingPlan = null)
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($callingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPlan = $callingPlan;
        return $this;
    }
    /**
     * Get callingPri value
     * @return string|null
     */
    public function getCallingPri()
    {
        return $this->callingPri;
    }
    /**
     * Set callingPri value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPri
     * @return RGatewayEndpointDigitalBri
     */
    public function setCallingPri($callingPri = null)
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($callingPri)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPri, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPri = $callingPri;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string|null
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @uses XClockReference::valueIsValid()
     * @uses XClockReference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clockReference
     * @return RGatewayEndpointDigitalBri
     */
    public function setClockReference($clockReference = null)
    {
        // validation for constraint: enumeration
        if (!XClockReference::valueIsValid($clockReference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $clockReference, implode(', ', XClockReference::getValidValues())), __LINE__);
        }
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string|null
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @uses XCSUParam::valueIsValid()
     * @uses XCSUParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $csuParam
     * @return RGatewayEndpointDigitalBri
     */
    public function setCsuParam($csuParam = null)
    {
        // validation for constraint: enumeration
        if (!XCSUParam::valueIsValid($csuParam)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $csuParam, implode(', ', XCSUParam::getValidValues())), __LINE__);
        }
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get dChannelEnable value
     * @return string|null
     */
    public function getDChannelEnable()
    {
        return $this->dChannelEnable;
    }
    /**
     * Set dChannelEnable value
     * @param string $dChannelEnable
     * @return RGatewayEndpointDigitalBri
     */
    public function setDChannelEnable($dChannelEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dChannelEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dChannelEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dChannelEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dChannelEnable) && !is_string($dChannelEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dChannelEnable)), __LINE__);
        }
        $this->dChannelEnable = $dChannelEnable;
        return $this;
    }
    /**
     * Get channelSelectionOrder value
     * @return string|null
     */
    public function getChannelSelectionOrder()
    {
        return $this->channelSelectionOrder;
    }
    /**
     * Set channelSelectionOrder value
     * @uses XTrunkSelectionOrder::valueIsValid()
     * @uses XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channelSelectionOrder
     * @return RGatewayEndpointDigitalBri
     */
    public function setChannelSelectionOrder($channelSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!XTrunkSelectionOrder::valueIsValid($channelSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channelSelectionOrder, implode(', ', XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->channelSelectionOrder = $channelSelectionOrder;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string|null
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @uses XEncode::valueIsValid()
     * @uses XEncode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pcmType
     * @return RGatewayEndpointDigitalBri
     */
    public function setPcmType($pcmType = null)
    {
        // validation for constraint: enumeration
        if (!XEncode::valueIsValid($pcmType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pcmType, implode(', ', XEncode::getValidValues())), __LINE__);
        }
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get firstDelay value
     * @return string|null
     */
    public function getFirstDelay()
    {
        return $this->firstDelay;
    }
    /**
     * Set firstDelay value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firstDelay
     * @return RGatewayEndpointDigitalBri
     */
    public function setFirstDelay($firstDelay = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($firstDelay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firstDelay, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->firstDelay = $firstDelay;
        return $this;
    }
    /**
     * Get intraDelay value
     * @return string|null
     */
    public function getIntraDelay()
    {
        return $this->intraDelay;
    }
    /**
     * Set intraDelay value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intraDelay
     * @return RGatewayEndpointDigitalBri
     */
    public function setIntraDelay($intraDelay = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($intraDelay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $intraDelay, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->intraDelay = $intraDelay;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return RGatewayEndpointDigitalBri
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectOutboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectOutboundNumberIe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectOutboundNumberIe) && !is_string($redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectOutboundNumberIe)), __LINE__);
        }
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get numDigitsToStrip value
     * @return string|null
     */
    public function getNumDigitsToStrip()
    {
        return $this->numDigitsToStrip;
    }
    /**
     * Set numDigitsToStrip value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numDigitsToStrip
     * @return RGatewayEndpointDigitalBri
     */
    public function setNumDigitsToStrip($numDigitsToStrip = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($numDigitsToStrip)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numDigitsToStrip, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->numDigitsToStrip = $numDigitsToStrip;
        return $this;
    }
    /**
     * Get prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return RGatewayEndpointDigitalBri
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string|null
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $presentationBit
     * @return RGatewayEndpointDigitalBri
     */
    public function setPresentationBit($presentationBit = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($presentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $presentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get sendRestart value
     * @return string|null
     */
    public function getSendRestart()
    {
        return $this->sendRestart;
    }
    /**
     * Set sendRestart value
     * @param string $sendRestart
     * @return RGatewayEndpointDigitalBri
     */
    public function setSendRestart($sendRestart = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendRestart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendRestart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendRestart, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendRestart) && !is_string($sendRestart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendRestart)), __LINE__);
        }
        $this->sendRestart = $sendRestart;
        return $this;
    }
    /**
     * Get setupNonIsdnPi value
     * @return string|null
     */
    public function getSetupNonIsdnPi()
    {
        return $this->setupNonIsdnPi;
    }
    /**
     * Set setupNonIsdnPi value
     * @param string $setupNonIsdnPi
     * @return RGatewayEndpointDigitalBri
     */
    public function setSetupNonIsdnPi($setupNonIsdnPi = null)
    {
        // validation for constraint: pattern
        if (is_scalar($setupNonIsdnPi) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $setupNonIsdnPi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($setupNonIsdnPi, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($setupNonIsdnPi) && !is_string($setupNonIsdnPi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($setupNonIsdnPi)), __LINE__);
        }
        $this->setupNonIsdnPi = $setupNonIsdnPi;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param SigDigits $sigDigits
     * @return RGatewayEndpointDigitalBri
     */
    public function setSigDigits(SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get statusPoll value
     * @return string|null
     */
    public function getStatusPoll()
    {
        return $this->statusPoll;
    }
    /**
     * Set statusPoll value
     * @param string $statusPoll
     * @return RGatewayEndpointDigitalBri
     */
    public function setStatusPoll($statusPoll = null)
    {
        // validation for constraint: pattern
        if (is_scalar($statusPoll) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $statusPoll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($statusPoll, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($statusPoll) && !is_string($statusPoll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusPoll)), __LINE__);
        }
        $this->statusPoll = $statusPoll;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses XPacketCaptureMode::valueIsValid()
     * @uses XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return RGatewayEndpointDigitalBri
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return RGatewayEndpointDigitalBri
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param XFkType $cdpnTransformationCssName
     * @return RGatewayEndpointDigitalBri
     */
    public function setCdpnTransformationCssName(XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return RGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param XFkType $geoLocationFilterName
     * @return RGatewayEndpointDigitalBri
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return RGatewayEndpointDigitalBri
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nationalPrefix) && strlen($nationalPrefix) > 16) || (is_array($nationalPrefix) && count($nationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($nationalPrefix) ? strlen($nationalPrefix) : count($nationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nationalPrefix) && !is_string($nationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalPrefix)), __LINE__);
        }
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return RGatewayEndpointDigitalBri
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($internationalPrefix) && strlen($internationalPrefix) > 16) || (is_array($internationalPrefix) && count($internationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($internationalPrefix) ? strlen($internationalPrefix) : count($internationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($internationalPrefix) && !is_string($internationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internationalPrefix)), __LINE__);
        }
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return RGatewayEndpointDigitalBri
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unknownPrefix) && strlen($unknownPrefix) > 16) || (is_array($unknownPrefix) && count($unknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($unknownPrefix) ? strlen($unknownPrefix) : count($unknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return RGatewayEndpointDigitalBri
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subscriberPrefix) && strlen($subscriberPrefix) > 16) || (is_array($subscriberPrefix) && count($subscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($subscriberPrefix) ? strlen($subscriberPrefix) : count($subscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subscriberPrefix) && !is_string($subscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberPrefix)), __LINE__);
        }
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return $this->nationalStripDigits;
    }
    /**
     * Set nationalStripDigits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nationalStripDigits
     * @return RGatewayEndpointDigitalBri
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($nationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nationalStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->nationalStripDigits = $nationalStripDigits;
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return $this->internationalStripDigits;
    }
    /**
     * Set internationalStripDigits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $internationalStripDigits
     * @return RGatewayEndpointDigitalBri
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($internationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $internationalStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->internationalStripDigits = $internationalStripDigits;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return $this->unknownStripDigits;
    }
    /**
     * Set unknownStripDigits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unknownStripDigits
     * @return RGatewayEndpointDigitalBri
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unknownStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->unknownStripDigits = $unknownStripDigits;
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return $this->subscriberStripDigits;
    }
    /**
     * Set subscriberStripDigits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberStripDigits
     * @return RGatewayEndpointDigitalBri
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($subscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriberStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->subscriberStripDigits = $subscriberStripDigits;
        return $this;
    }
    /**
     * Get nationalTransformationCssName value
     * @return XFkType|null
     */
    public function getNationalTransformationCssName()
    {
        return $this->nationalTransformationCssName;
    }
    /**
     * Set nationalTransformationCssName value
     * @param XFkType $nationalTransformationCssName
     * @return RGatewayEndpointDigitalBri
     */
    public function setNationalTransformationCssName(XFkType $nationalTransformationCssName = null)
    {
        $this->nationalTransformationCssName = $nationalTransformationCssName;
        return $this;
    }
    /**
     * Get internationalTransformationCssName value
     * @return XFkType|null
     */
    public function getInternationalTransformationCssName()
    {
        return $this->internationalTransformationCssName;
    }
    /**
     * Set internationalTransformationCssName value
     * @param XFkType $internationalTransformationCssName
     * @return RGatewayEndpointDigitalBri
     */
    public function setInternationalTransformationCssName(XFkType $internationalTransformationCssName = null)
    {
        $this->internationalTransformationCssName = $internationalTransformationCssName;
        return $this;
    }
    /**
     * Get unknownTransformationCssName value
     * @return XFkType|null
     */
    public function getUnknownTransformationCssName()
    {
        return $this->unknownTransformationCssName;
    }
    /**
     * Set unknownTransformationCssName value
     * @param XFkType $unknownTransformationCssName
     * @return RGatewayEndpointDigitalBri
     */
    public function setUnknownTransformationCssName(XFkType $unknownTransformationCssName = null)
    {
        $this->unknownTransformationCssName = $unknownTransformationCssName;
        return $this;
    }
    /**
     * Get subscriberTransformationCssName value
     * @return XFkType|null
     */
    public function getSubscriberTransformationCssName()
    {
        return $this->subscriberTransformationCssName;
    }
    /**
     * Set subscriberTransformationCssName value
     * @param XFkType $subscriberTransformationCssName
     * @return RGatewayEndpointDigitalBri
     */
    public function setSubscriberTransformationCssName(XFkType $subscriberTransformationCssName = null)
    {
        $this->subscriberTransformationCssName = $subscriberTransformationCssName;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return RGatewayEndpointDigitalBri
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param XFkType $imeE164TransformationName
     * @return RGatewayEndpointDigitalBri
     */
    public function setImeE164TransformationName(XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return RGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssNatl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssNatl) && !is_string($useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssNatl)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return RGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssIntl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssIntl) && !is_string($useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssIntl)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return RGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return RGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssSubs, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssSubs) && !is_string($useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssSubs)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get GClearEnable value
     * @return string|null
     */
    public function getGClearEnable()
    {
        return $this->GClearEnable;
    }
    /**
     * Set GClearEnable value
     * @param string $gClearEnable
     * @return RGatewayEndpointDigitalBri
     */
    public function setGClearEnable($gClearEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gClearEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $gClearEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($gClearEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gClearEnable) && !is_string($gClearEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gClearEnable)), __LINE__);
        }
        $this->GClearEnable = $gClearEnable;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return RGatewayEndpointDigitalBri
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RGatewayEndpointDigitalBri
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RGatewayEndpointDigitalBri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
