<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RExternalCallControlProfile StructType
 * @subpackage Structs
 */
class RExternalCallControlProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The primaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $primaryUri;
    /**
     * The secondaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $secondaryUri;
    /**
     * The enableLoadBalancing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableLoadBalancing;
    /**
     * The routingRequestTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routingRequestTimer;
    /**
     * The diversionReroutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $diversionReroutingCssName;
    /**
     * The callTreatmentOnFailure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callTreatmentOnFailure;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RExternalCallControlProfile
     * @uses RExternalCallControlProfile::setName()
     * @uses RExternalCallControlProfile::setPrimaryUri()
     * @uses RExternalCallControlProfile::setSecondaryUri()
     * @uses RExternalCallControlProfile::setEnableLoadBalancing()
     * @uses RExternalCallControlProfile::setRoutingRequestTimer()
     * @uses RExternalCallControlProfile::setDiversionReroutingCssName()
     * @uses RExternalCallControlProfile::setCallTreatmentOnFailure()
     * @uses RExternalCallControlProfile::setUuid()
     * @param string $name
     * @param string $primaryUri
     * @param string $secondaryUri
     * @param string $enableLoadBalancing
     * @param string $routingRequestTimer
     * @param XFkType $diversionReroutingCssName
     * @param string $callTreatmentOnFailure
     * @param string $uuid
     */
    public function __construct($name = null, $primaryUri = null, $secondaryUri = null, $enableLoadBalancing = null, $routingRequestTimer = null, XFkType $diversionReroutingCssName = null, $callTreatmentOnFailure = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setPrimaryUri($primaryUri)
            ->setSecondaryUri($secondaryUri)
            ->setEnableLoadBalancing($enableLoadBalancing)
            ->setRoutingRequestTimer($routingRequestTimer)
            ->setDiversionReroutingCssName($diversionReroutingCssName)
            ->setCallTreatmentOnFailure($callTreatmentOnFailure)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RExternalCallControlProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get primaryUri value
     * @return string|null
     */
    public function getPrimaryUri()
    {
        return $this->primaryUri;
    }
    /**
     * Set primaryUri value
     * @param string $primaryUri
     * @return RExternalCallControlProfile
     */
    public function setPrimaryUri($primaryUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($primaryUri) && strlen($primaryUri) > 255) || (is_array($primaryUri) && count($primaryUri) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($primaryUri) ? strlen($primaryUri) : count($primaryUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($primaryUri) && !is_string($primaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryUri)), __LINE__);
        }
        $this->primaryUri = $primaryUri;
        return $this;
    }
    /**
     * Get secondaryUri value
     * @return string|null
     */
    public function getSecondaryUri()
    {
        return $this->secondaryUri;
    }
    /**
     * Set secondaryUri value
     * @param string $secondaryUri
     * @return RExternalCallControlProfile
     */
    public function setSecondaryUri($secondaryUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secondaryUri) && strlen($secondaryUri) > 255) || (is_array($secondaryUri) && count($secondaryUri) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secondaryUri) ? strlen($secondaryUri) : count($secondaryUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secondaryUri) && !is_string($secondaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryUri)), __LINE__);
        }
        $this->secondaryUri = $secondaryUri;
        return $this;
    }
    /**
     * Get enableLoadBalancing value
     * @return string|null
     */
    public function getEnableLoadBalancing()
    {
        return $this->enableLoadBalancing;
    }
    /**
     * Set enableLoadBalancing value
     * @param string $enableLoadBalancing
     * @return RExternalCallControlProfile
     */
    public function setEnableLoadBalancing($enableLoadBalancing = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableLoadBalancing) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableLoadBalancing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableLoadBalancing, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableLoadBalancing) && !is_string($enableLoadBalancing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableLoadBalancing)), __LINE__);
        }
        $this->enableLoadBalancing = $enableLoadBalancing;
        return $this;
    }
    /**
     * Get routingRequestTimer value
     * @return string|null
     */
    public function getRoutingRequestTimer()
    {
        return $this->routingRequestTimer;
    }
    /**
     * Set routingRequestTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routingRequestTimer
     * @return RExternalCallControlProfile
     */
    public function setRoutingRequestTimer($routingRequestTimer = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($routingRequestTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routingRequestTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->routingRequestTimer = $routingRequestTimer;
        return $this;
    }
    /**
     * Get diversionReroutingCssName value
     * @return XFkType|null
     */
    public function getDiversionReroutingCssName()
    {
        return $this->diversionReroutingCssName;
    }
    /**
     * Set diversionReroutingCssName value
     * @param XFkType $diversionReroutingCssName
     * @return RExternalCallControlProfile
     */
    public function setDiversionReroutingCssName(XFkType $diversionReroutingCssName = null)
    {
        $this->diversionReroutingCssName = $diversionReroutingCssName;
        return $this;
    }
    /**
     * Get callTreatmentOnFailure value
     * @return string|null
     */
    public function getCallTreatmentOnFailure()
    {
        return $this->callTreatmentOnFailure;
    }
    /**
     * Set callTreatmentOnFailure value
     * @uses XCallTreatmentOnFailure::valueIsValid()
     * @uses XCallTreatmentOnFailure::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callTreatmentOnFailure
     * @return RExternalCallControlProfile
     */
    public function setCallTreatmentOnFailure($callTreatmentOnFailure = null)
    {
        // validation for constraint: enumeration
        if (!XCallTreatmentOnFailure::valueIsValid($callTreatmentOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callTreatmentOnFailure, implode(', ', XCallTreatmentOnFailure::getValidValues())), __LINE__);
        }
        $this->callTreatmentOnFailure = $callTreatmentOnFailure;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RExternalCallControlProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RExternalCallControlProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
