<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDirectoryLookupDialRules StructType
 * @subpackage Structs
 */
class RDirectoryLookupDialRules extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The numberBeginWith
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberBeginWith;
    /**
     * The numberOfDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfDigits;
    /**
     * The digitsToBeRemoved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digitsToBeRemoved;
    /**
     * The prefixPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prefixPattern;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDirectoryLookupDialRules
     * @uses RDirectoryLookupDialRules::setName()
     * @uses RDirectoryLookupDialRules::setDescription()
     * @uses RDirectoryLookupDialRules::setNumberBeginWith()
     * @uses RDirectoryLookupDialRules::setNumberOfDigits()
     * @uses RDirectoryLookupDialRules::setDigitsToBeRemoved()
     * @uses RDirectoryLookupDialRules::setPrefixPattern()
     * @uses RDirectoryLookupDialRules::setPriority()
     * @uses RDirectoryLookupDialRules::setUuid()
     * @param string $name
     * @param string $description
     * @param string $numberBeginWith
     * @param string $numberOfDigits
     * @param string $digitsToBeRemoved
     * @param string $prefixPattern
     * @param string $priority
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $numberBeginWith = null, $numberOfDigits = null, $digitsToBeRemoved = null, $prefixPattern = null, $priority = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setNumberBeginWith($numberBeginWith)
            ->setNumberOfDigits($numberOfDigits)
            ->setDigitsToBeRemoved($digitsToBeRemoved)
            ->setPrefixPattern($prefixPattern)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RDirectoryLookupDialRules
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RDirectoryLookupDialRules
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get numberBeginWith value
     * @return string|null
     */
    public function getNumberBeginWith()
    {
        return $this->numberBeginWith;
    }
    /**
     * Set numberBeginWith value
     * @param string $numberBeginWith
     * @return RDirectoryLookupDialRules
     */
    public function setNumberBeginWith($numberBeginWith = null)
    {
        // validation for constraint: string
        if (!is_null($numberBeginWith) && !is_string($numberBeginWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberBeginWith)), __LINE__);
        }
        $this->numberBeginWith = $numberBeginWith;
        return $this;
    }
    /**
     * Get numberOfDigits value
     * @return string|null
     */
    public function getNumberOfDigits()
    {
        return $this->numberOfDigits;
    }
    /**
     * Set numberOfDigits value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigits
     * @return RDirectoryLookupDialRules
     */
    public function setNumberOfDigits($numberOfDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($numberOfDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigits = $numberOfDigits;
        return $this;
    }
    /**
     * Get digitsToBeRemoved value
     * @return string|null
     */
    public function getDigitsToBeRemoved()
    {
        return $this->digitsToBeRemoved;
    }
    /**
     * Set digitsToBeRemoved value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitsToBeRemoved
     * @return RDirectoryLookupDialRules
     */
    public function setDigitsToBeRemoved($digitsToBeRemoved = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($digitsToBeRemoved)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $digitsToBeRemoved, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->digitsToBeRemoved = $digitsToBeRemoved;
        return $this;
    }
    /**
     * Get prefixPattern value
     * @return string|null
     */
    public function getPrefixPattern()
    {
        return $this->prefixPattern;
    }
    /**
     * Set prefixPattern value
     * @param string $prefixPattern
     * @return RDirectoryLookupDialRules
     */
    public function setPrefixPattern($prefixPattern = null)
    {
        // validation for constraint: string
        if (!is_null($prefixPattern) && !is_string($prefixPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixPattern)), __LINE__);
        }
        $this->prefixPattern = $prefixPattern;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return RDirectoryLookupDialRules
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RDirectoryLookupDialRules
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RDirectoryLookupDialRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
