<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDateTimeGroup StructType
 * @subpackage Structs
 */
class RDateTimeGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The separator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $separator;
    /**
     * The dateformat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dateformat;
    /**
     * The timeFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeFormat;
    /**
     * The phoneNtpReferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PhoneNtpReferences
     */
    public $phoneNtpReferences;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDateTimeGroup
     * @uses RDateTimeGroup::setName()
     * @uses RDateTimeGroup::setTimeZone()
     * @uses RDateTimeGroup::setSeparator()
     * @uses RDateTimeGroup::setDateformat()
     * @uses RDateTimeGroup::setTimeFormat()
     * @uses RDateTimeGroup::setPhoneNtpReferences()
     * @uses RDateTimeGroup::setUuid()
     * @param string $name
     * @param string $timeZone
     * @param string $separator
     * @param string $dateformat
     * @param string $timeFormat
     * @param PhoneNtpReferences $phoneNtpReferences
     * @param string $uuid
     */
    public function __construct($name = null, $timeZone = null, $separator = null, $dateformat = null, $timeFormat = null, PhoneNtpReferences $phoneNtpReferences = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setTimeZone($timeZone)
            ->setSeparator($separator)
            ->setDateformat($dateformat)
            ->setTimeFormat($timeFormat)
            ->setPhoneNtpReferences($phoneNtpReferences)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RDateTimeGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses XTimeZone::valueIsValid()
     * @uses XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return RDateTimeGroup
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get separator value
     * @return string|null
     */
    public function getSeparator()
    {
        return $this->separator;
    }
    /**
     * Set separator value
     * @param string $separator
     * @return RDateTimeGroup
     */
    public function setSeparator($separator = null)
    {
        // validation for constraint: string
        if (!is_null($separator) && !is_string($separator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($separator)), __LINE__);
        }
        $this->separator = $separator;
        return $this;
    }
    /**
     * Get dateformat value
     * @return string|null
     */
    public function getDateformat()
    {
        return $this->dateformat;
    }
    /**
     * Set dateformat value
     * @param string $dateformat
     * @return RDateTimeGroup
     */
    public function setDateformat($dateformat = null)
    {
        // validation for constraint: string
        if (!is_null($dateformat) && !is_string($dateformat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateformat)), __LINE__);
        }
        $this->dateformat = $dateformat;
        return $this;
    }
    /**
     * Get timeFormat value
     * @return string|null
     */
    public function getTimeFormat()
    {
        return $this->timeFormat;
    }
    /**
     * Set timeFormat value
     * @param string $timeFormat
     * @return RDateTimeGroup
     */
    public function setTimeFormat($timeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($timeFormat) && !is_string($timeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeFormat)), __LINE__);
        }
        $this->timeFormat = $timeFormat;
        return $this;
    }
    /**
     * Get phoneNtpReferences value
     * @return PhoneNtpReferences|null
     */
    public function getPhoneNtpReferences()
    {
        return $this->phoneNtpReferences;
    }
    /**
     * Set phoneNtpReferences value
     * @param PhoneNtpReferences $phoneNtpReferences
     * @return RDateTimeGroup
     */
    public function setPhoneNtpReferences(PhoneNtpReferences $phoneNtpReferences = null)
    {
        $this->phoneNtpReferences = $phoneNtpReferences;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RDateTimeGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RDateTimeGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
