<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCumaServerSecurityProfile StructType
 * @subpackage Structs
 */
class RCumaServerSecurityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $securityMode;
    /**
     * The transportType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transportType;
    /**
     * The x509SubjectName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $x509SubjectName;
    /**
     * The serverIpHostName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $serverIpHostName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCumaServerSecurityProfile
     * @uses RCumaServerSecurityProfile::setName()
     * @uses RCumaServerSecurityProfile::setDescription()
     * @uses RCumaServerSecurityProfile::setSecurityMode()
     * @uses RCumaServerSecurityProfile::setTransportType()
     * @uses RCumaServerSecurityProfile::setX509SubjectName()
     * @uses RCumaServerSecurityProfile::setServerIpHostName()
     * @uses RCumaServerSecurityProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $securityMode
     * @param string $transportType
     * @param string $x509SubjectName
     * @param string $serverIpHostName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $securityMode = null, $transportType = null, $x509SubjectName = null, $serverIpHostName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setTransportType($transportType)
            ->setX509SubjectName($x509SubjectName)
            ->setServerIpHostName($serverIpHostName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RCumaServerSecurityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RCumaServerSecurityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get securityMode value
     * @return string|null
     */
    public function getSecurityMode()
    {
        return $this->securityMode;
    }
    /**
     * Set securityMode value
     * @uses XDeviceSecurityMode::valueIsValid()
     * @uses XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return RCumaServerSecurityProfile
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $securityMode, implode(', ', XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        $this->securityMode = $securityMode;
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses XTransport::valueIsValid()
     * @uses XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return RCumaServerSecurityProfile
     */
    public function setTransportType($transportType = null)
    {
        // validation for constraint: enumeration
        if (!XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transportType, implode(', ', XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return RCumaServerSecurityProfile
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get serverIpHostName value
     * @return string|null
     */
    public function getServerIpHostName()
    {
        return $this->serverIpHostName;
    }
    /**
     * Set serverIpHostName value
     * @param string $serverIpHostName
     * @return RCumaServerSecurityProfile
     */
    public function setServerIpHostName($serverIpHostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serverIpHostName) && strlen($serverIpHostName) > 255) || (is_array($serverIpHostName) && count($serverIpHostName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($serverIpHostName) ? strlen($serverIpHostName) : count($serverIpHostName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serverIpHostName) && !is_string($serverIpHostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverIpHostName)), __LINE__);
        }
        $this->serverIpHostName = $serverIpHostName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RCumaServerSecurityProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RCumaServerSecurityProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
