<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCcdRequestingServiceMember StructType
 * @subpackage Structs
 */
class RCcdRequestingServiceMember extends AbstractStructBase
{
    /**
     * The trunkName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $trunkName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCcdRequestingServiceMember
     * @uses RCcdRequestingServiceMember::setTrunkName()
     * @uses RCcdRequestingServiceMember::setUuid()
     * @param XFkType $trunkName
     * @param string $uuid
     */
    public function __construct(XFkType $trunkName = null, $uuid = null)
    {
        $this
            ->setTrunkName($trunkName)
            ->setUuid($uuid);
    }
    /**
     * Get trunkName value
     * @return XFkType|null
     */
    public function getTrunkName()
    {
        return $this->trunkName;
    }
    /**
     * Set trunkName value
     * @param XFkType $trunkName
     * @return RCcdRequestingServiceMember
     */
    public function setTrunkName(XFkType $trunkName = null)
    {
        $this->trunkName = $trunkName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RCcdRequestingServiceMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RCcdRequestingServiceMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
