<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAudioCodecPreferenceList StructType
 * @subpackage Structs
 */
class RAudioCodecPreferenceList extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The codecsInList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CodecsInList
     */
    public $codecsInList;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAudioCodecPreferenceList
     * @uses RAudioCodecPreferenceList::setName()
     * @uses RAudioCodecPreferenceList::setDescription()
     * @uses RAudioCodecPreferenceList::setCodecsInList()
     * @uses RAudioCodecPreferenceList::setUuid()
     * @param string $name
     * @param string $description
     * @param CodecsInList $codecsInList
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, CodecsInList $codecsInList = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setCodecsInList($codecsInList)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RAudioCodecPreferenceList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RAudioCodecPreferenceList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get codecsInList value
     * @return CodecsInList|null
     */
    public function getCodecsInList()
    {
        return $this->codecsInList;
    }
    /**
     * Set codecsInList value
     * @param CodecsInList $codecsInList
     * @return RAudioCodecPreferenceList
     */
    public function setCodecsInList(CodecsInList $codecsInList = null)
    {
        $this->codecsInList = $codecsInList;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RAudioCodecPreferenceList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RAudioCodecPreferenceList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
