<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVpnGroupMember StructType
 * @subpackage Structs
 */
class LVpnGroupMember extends AbstractStructBase
{
    /**
     * The vpnGatewayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $vpnGatewayName;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVpnGroupMember
     * @uses LVpnGroupMember::setVpnGatewayName()
     * @uses LVpnGroupMember::setPriority()
     * @uses LVpnGroupMember::setUuid()
     * @param XFkType $vpnGatewayName
     * @param string $priority
     * @param string $uuid
     */
    public function __construct(XFkType $vpnGatewayName = null, $priority = null, $uuid = null)
    {
        $this
            ->setVpnGatewayName($vpnGatewayName)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get vpnGatewayName value
     * @return XFkType|null
     */
    public function getVpnGatewayName()
    {
        return $this->vpnGatewayName;
    }
    /**
     * Set vpnGatewayName value
     * @param XFkType $vpnGatewayName
     * @return LVpnGroupMember
     */
    public function setVpnGatewayName(XFkType $vpnGatewayName = null)
    {
        $this->vpnGatewayName = $vpnGatewayName;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return LVpnGroupMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LVpnGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LVpnGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
