<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LSipProfile StructType
 * @subpackage Structs
 */
class LSipProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $description;
    /**
     * The defaultTelephonyEventPayloadType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $defaultTelephonyEventPayloadType;
    /**
     * The redirectByApplication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectByApplication;
    /**
     * The ringing180
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ringing180;
    /**
     * The timerInvite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerInvite;
    /**
     * The timerRegisterDelta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerRegisterDelta;
    /**
     * The timerRegister
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerRegister;
    /**
     * The timerT1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerT1;
    /**
     * The timerT2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerT2;
    /**
     * The retryInvite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryInvite;
    /**
     * The retryNotInvite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryNotInvite;
    /**
     * The startMediaPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $startMediaPort;
    /**
     * The stopMediaPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $stopMediaPort;
    /**
     * The callpickupUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $callpickupUri;
    /**
     * The callpickupListUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $callpickupListUri;
    /**
     * The callpickupGroupUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $callpickupGroupUri;
    /**
     * The meetmeServiceUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $meetmeServiceUrl;
    /**
     * The userInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telnetLevel;
    /**
     * The timerKeepAlive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerKeepAlive;
    /**
     * The timerSubscribe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerSubscribe;
    /**
     * The timerSubscribeDelta
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerSubscribeDelta;
    /**
     * The maxRedirects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxRedirects;
    /**
     * The timerOffHookToFirstDigit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timerOffHookToFirstDigit;
    /**
     * The callForwardUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $callForwardUri;
    /**
     * The abbreviatedDialUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $abbreviatedDialUri;
    /**
     * The confJointEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $confJointEnable;
    /**
     * The rfc2543Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2543Hold;
    /**
     * The semiAttendedTransfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $semiAttendedTransfer;
    /**
     * The enableVad
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableVad;
    /**
     * The stutterMsgWaiting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $stutterMsgWaiting;
    /**
     * The callStats
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callStats;
    /**
     * The t38Invite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $t38Invite;
    /**
     * The rerouteIncomingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The enableAnatForEarlyOfferCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableAnatForEarlyOfferCalls;
    /**
     * The rsvpOverSip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rsvpOverSip;
    /**
     * The fallbackToLocalRsvp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $fallbackToLocalRsvp;
    /**
     * The sipRe11XxEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gClear;
    /**
     * The earlyOfferSupportForVoiceCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $earlyOfferSupportForVoiceCall;
    /**
     * The sendRecvSDPInMidCallInvite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRecvSDPInMidCallInvite;
    /**
     * The enableOutboundOptionsPing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundOptionsPing;
    /**
     * The optionsPingIntervalWhenStatusOK
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsPingIntervalWhenStatusOK;
    /**
     * The optionsPingIntervalWhenStatusNotOK
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $optionsPingIntervalWhenStatusNotOK;
    /**
     * The deliverConferenceBridgeIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $deliverConferenceBridgeIdentifier;
    /**
     * The sipOptionsRetryCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipOptionsRetryCount;
    /**
     * The sipOptionsRetryTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipOptionsRetryTimer;
    /**
     * The sipBandwidthModifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sipBandwidthModifier;
    /**
     * The enableUriOutdialSupport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enableUriOutdialSupport;
    /**
     * The userAgentServerHeaderInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userAgentServerHeaderInfo;
    /**
     * The allowPresentationSharingUsingBfcp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowPresentationSharingUsingBfcp;
    /**
     * The scriptParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scriptParameters;
    /**
     * The isScriptTraceEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isScriptTraceEnabled;
    /**
     * The sipNormalizationScript
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $sipNormalizationScript;
    /**
     * The allowiXApplicationMedia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowiXApplicationMedia;
    /**
     * The dialStringInterpretation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $acceptAudioCodecPreferences;
    /**
     * The mlppUserAuthorization
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mlppUserAuthorization;
    /**
     * The isAssuredSipServiceEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isAssuredSipServiceEnabled;
    /**
     * The resourcePriorityNamespace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The useCallerIdCallerNameinUriOutgoingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerIdCallerNameinUriOutgoingRequest;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callerIdDn;
    /**
     * The callerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callerName;
    /**
     * The callingLineIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLineIdentification;
    /**
     * The rejectAnonymousIncomingCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousIncomingCall;
    /**
     * The rejectAnonymousOutgoingCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousOutgoingCall;
    /**
     * The videoCallTrafficClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoCallTrafficClass;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LSipProfile
     * @uses LSipProfile::setName()
     * @uses LSipProfile::setDescription()
     * @uses LSipProfile::setDefaultTelephonyEventPayloadType()
     * @uses LSipProfile::setRedirectByApplication()
     * @uses LSipProfile::setRinging180()
     * @uses LSipProfile::setTimerInvite()
     * @uses LSipProfile::setTimerRegisterDelta()
     * @uses LSipProfile::setTimerRegister()
     * @uses LSipProfile::setTimerT1()
     * @uses LSipProfile::setTimerT2()
     * @uses LSipProfile::setRetryInvite()
     * @uses LSipProfile::setRetryNotInvite()
     * @uses LSipProfile::setStartMediaPort()
     * @uses LSipProfile::setStopMediaPort()
     * @uses LSipProfile::setCallpickupUri()
     * @uses LSipProfile::setCallpickupListUri()
     * @uses LSipProfile::setCallpickupGroupUri()
     * @uses LSipProfile::setMeetmeServiceUrl()
     * @uses LSipProfile::setUserInfo()
     * @uses LSipProfile::setDtmfDbLevel()
     * @uses LSipProfile::setCallHoldRingback()
     * @uses LSipProfile::setAnonymousCallBlock()
     * @uses LSipProfile::setCallerIdBlock()
     * @uses LSipProfile::setDndControl()
     * @uses LSipProfile::setTelnetLevel()
     * @uses LSipProfile::setTimerKeepAlive()
     * @uses LSipProfile::setTimerSubscribe()
     * @uses LSipProfile::setTimerSubscribeDelta()
     * @uses LSipProfile::setMaxRedirects()
     * @uses LSipProfile::setTimerOffHookToFirstDigit()
     * @uses LSipProfile::setCallForwardUri()
     * @uses LSipProfile::setAbbreviatedDialUri()
     * @uses LSipProfile::setConfJointEnable()
     * @uses LSipProfile::setRfc2543Hold()
     * @uses LSipProfile::setSemiAttendedTransfer()
     * @uses LSipProfile::setEnableVad()
     * @uses LSipProfile::setStutterMsgWaiting()
     * @uses LSipProfile::setCallStats()
     * @uses LSipProfile::setT38Invite()
     * @uses LSipProfile::setRerouteIncomingRequest()
     * @uses LSipProfile::setResourcePriorityNamespaceListName()
     * @uses LSipProfile::setEnableAnatForEarlyOfferCalls()
     * @uses LSipProfile::setRsvpOverSip()
     * @uses LSipProfile::setFallbackToLocalRsvp()
     * @uses LSipProfile::setSipRe11XxEnabled()
     * @uses LSipProfile::setGClear()
     * @uses LSipProfile::setEarlyOfferSupportForVoiceCall()
     * @uses LSipProfile::setSendRecvSDPInMidCallInvite()
     * @uses LSipProfile::setEnableOutboundOptionsPing()
     * @uses LSipProfile::setOptionsPingIntervalWhenStatusOK()
     * @uses LSipProfile::setOptionsPingIntervalWhenStatusNotOK()
     * @uses LSipProfile::setDeliverConferenceBridgeIdentifier()
     * @uses LSipProfile::setSipOptionsRetryCount()
     * @uses LSipProfile::setSipOptionsRetryTimer()
     * @uses LSipProfile::setSipBandwidthModifier()
     * @uses LSipProfile::setEnableUriOutdialSupport()
     * @uses LSipProfile::setUserAgentServerHeaderInfo()
     * @uses LSipProfile::setAllowPresentationSharingUsingBfcp()
     * @uses LSipProfile::setScriptParameters()
     * @uses LSipProfile::setIsScriptTraceEnabled()
     * @uses LSipProfile::setSipNormalizationScript()
     * @uses LSipProfile::setAllowiXApplicationMedia()
     * @uses LSipProfile::setDialStringInterpretation()
     * @uses LSipProfile::setAcceptAudioCodecPreferences()
     * @uses LSipProfile::setMlppUserAuthorization()
     * @uses LSipProfile::setIsAssuredSipServiceEnabled()
     * @uses LSipProfile::setResourcePriorityNamespace()
     * @uses LSipProfile::setUseCallerIdCallerNameinUriOutgoingRequest()
     * @uses LSipProfile::setCallerIdDn()
     * @uses LSipProfile::setCallerName()
     * @uses LSipProfile::setCallingLineIdentification()
     * @uses LSipProfile::setRejectAnonymousIncomingCall()
     * @uses LSipProfile::setRejectAnonymousOutgoingCall()
     * @uses LSipProfile::setVideoCallTrafficClass()
     * @uses LSipProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $defaultTelephonyEventPayloadType
     * @param string $redirectByApplication
     * @param string $ringing180
     * @param string $timerInvite
     * @param string $timerRegisterDelta
     * @param string $timerRegister
     * @param string $timerT1
     * @param string $timerT2
     * @param string $retryInvite
     * @param string $retryNotInvite
     * @param string $startMediaPort
     * @param string $stopMediaPort
     * @param string $callpickupUri
     * @param string $callpickupListUri
     * @param string $callpickupGroupUri
     * @param string $meetmeServiceUrl
     * @param string $userInfo
     * @param string $dtmfDbLevel
     * @param string $callHoldRingback
     * @param string $anonymousCallBlock
     * @param string $callerIdBlock
     * @param string $dndControl
     * @param string $telnetLevel
     * @param string $timerKeepAlive
     * @param string $timerSubscribe
     * @param string $timerSubscribeDelta
     * @param string $maxRedirects
     * @param string $timerOffHookToFirstDigit
     * @param string $callForwardUri
     * @param string $abbreviatedDialUri
     * @param string $confJointEnable
     * @param string $rfc2543Hold
     * @param string $semiAttendedTransfer
     * @param string $enableVad
     * @param string $stutterMsgWaiting
     * @param string $callStats
     * @param string $t38Invite
     * @param string $rerouteIncomingRequest
     * @param XFkType $resourcePriorityNamespaceListName
     * @param string $enableAnatForEarlyOfferCalls
     * @param string $rsvpOverSip
     * @param string $fallbackToLocalRsvp
     * @param string $sipRe11XxEnabled
     * @param string $gClear
     * @param string $earlyOfferSupportForVoiceCall
     * @param string $sendRecvSDPInMidCallInvite
     * @param string $enableOutboundOptionsPing
     * @param string $optionsPingIntervalWhenStatusOK
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @param string $deliverConferenceBridgeIdentifier
     * @param string $sipOptionsRetryCount
     * @param string $sipOptionsRetryTimer
     * @param string $sipBandwidthModifier
     * @param string $enableUriOutdialSupport
     * @param string $userAgentServerHeaderInfo
     * @param string $allowPresentationSharingUsingBfcp
     * @param string $scriptParameters
     * @param string $isScriptTraceEnabled
     * @param XFkType $sipNormalizationScript
     * @param string $allowiXApplicationMedia
     * @param string $dialStringInterpretation
     * @param string $acceptAudioCodecPreferences
     * @param string $mlppUserAuthorization
     * @param string $isAssuredSipServiceEnabled
     * @param XFkType $resourcePriorityNamespace
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @param string $callerIdDn
     * @param string $callerName
     * @param string $callingLineIdentification
     * @param string $rejectAnonymousIncomingCall
     * @param string $rejectAnonymousOutgoingCall
     * @param string $videoCallTrafficClass
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $defaultTelephonyEventPayloadType = null, $redirectByApplication = null, $ringing180 = null, $timerInvite = null, $timerRegisterDelta = null, $timerRegister = null, $timerT1 = null, $timerT2 = null, $retryInvite = null, $retryNotInvite = null, $startMediaPort = null, $stopMediaPort = null, $callpickupUri = null, $callpickupListUri = null, $callpickupGroupUri = null, $meetmeServiceUrl = null, $userInfo = null, $dtmfDbLevel = null, $callHoldRingback = null, $anonymousCallBlock = null, $callerIdBlock = null, $dndControl = null, $telnetLevel = null, $timerKeepAlive = null, $timerSubscribe = null, $timerSubscribeDelta = null, $maxRedirects = null, $timerOffHookToFirstDigit = null, $callForwardUri = null, $abbreviatedDialUri = null, $confJointEnable = null, $rfc2543Hold = null, $semiAttendedTransfer = null, $enableVad = null, $stutterMsgWaiting = null, $callStats = null, $t38Invite = null, $rerouteIncomingRequest = null, XFkType $resourcePriorityNamespaceListName = null, $enableAnatForEarlyOfferCalls = null, $rsvpOverSip = null, $fallbackToLocalRsvp = null, $sipRe11XxEnabled = null, $gClear = null, $earlyOfferSupportForVoiceCall = null, $sendRecvSDPInMidCallInvite = null, $enableOutboundOptionsPing = null, $optionsPingIntervalWhenStatusOK = null, $optionsPingIntervalWhenStatusNotOK = null, $deliverConferenceBridgeIdentifier = null, $sipOptionsRetryCount = null, $sipOptionsRetryTimer = null, $sipBandwidthModifier = null, $enableUriOutdialSupport = null, $userAgentServerHeaderInfo = null, $allowPresentationSharingUsingBfcp = null, $scriptParameters = null, $isScriptTraceEnabled = null, XFkType $sipNormalizationScript = null, $allowiXApplicationMedia = null, $dialStringInterpretation = null, $acceptAudioCodecPreferences = null, $mlppUserAuthorization = null, $isAssuredSipServiceEnabled = null, XFkType $resourcePriorityNamespace = null, $useCallerIdCallerNameinUriOutgoingRequest = null, $callerIdDn = null, $callerName = null, $callingLineIdentification = null, $rejectAnonymousIncomingCall = null, $rejectAnonymousOutgoingCall = null, $videoCallTrafficClass = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType)
            ->setRedirectByApplication($redirectByApplication)
            ->setRinging180($ringing180)
            ->setTimerInvite($timerInvite)
            ->setTimerRegisterDelta($timerRegisterDelta)
            ->setTimerRegister($timerRegister)
            ->setTimerT1($timerT1)
            ->setTimerT2($timerT2)
            ->setRetryInvite($retryInvite)
            ->setRetryNotInvite($retryNotInvite)
            ->setStartMediaPort($startMediaPort)
            ->setStopMediaPort($stopMediaPort)
            ->setCallpickupUri($callpickupUri)
            ->setCallpickupListUri($callpickupListUri)
            ->setCallpickupGroupUri($callpickupGroupUri)
            ->setMeetmeServiceUrl($meetmeServiceUrl)
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setTimerKeepAlive($timerKeepAlive)
            ->setTimerSubscribe($timerSubscribe)
            ->setTimerSubscribeDelta($timerSubscribeDelta)
            ->setMaxRedirects($maxRedirects)
            ->setTimerOffHookToFirstDigit($timerOffHookToFirstDigit)
            ->setCallForwardUri($callForwardUri)
            ->setAbbreviatedDialUri($abbreviatedDialUri)
            ->setConfJointEnable($confJointEnable)
            ->setRfc2543Hold($rfc2543Hold)
            ->setSemiAttendedTransfer($semiAttendedTransfer)
            ->setEnableVad($enableVad)
            ->setStutterMsgWaiting($stutterMsgWaiting)
            ->setCallStats($callStats)
            ->setT38Invite($t38Invite)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls)
            ->setRsvpOverSip($rsvpOverSip)
            ->setFallbackToLocalRsvp($fallbackToLocalRsvp)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall)
            ->setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite)
            ->setEnableOutboundOptionsPing($enableOutboundOptionsPing)
            ->setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK)
            ->setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK)
            ->setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier)
            ->setSipOptionsRetryCount($sipOptionsRetryCount)
            ->setSipOptionsRetryTimer($sipOptionsRetryTimer)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setEnableUriOutdialSupport($enableUriOutdialSupport)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp)
            ->setScriptParameters($scriptParameters)
            ->setIsScriptTraceEnabled($isScriptTraceEnabled)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setAllowiXApplicationMedia($allowiXApplicationMedia)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setMlppUserAuthorization($mlppUserAuthorization)
            ->setIsAssuredSipServiceEnabled($isAssuredSipServiceEnabled)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest)
            ->setCallerIdDn($callerIdDn)
            ->setCallerName($callerName)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setRejectAnonymousIncomingCall($rejectAnonymousIncomingCall)
            ->setRejectAnonymousOutgoingCall($rejectAnonymousOutgoingCall)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LSipProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LSipProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get defaultTelephonyEventPayloadType value
     * @return string|null
     */
    public function getDefaultTelephonyEventPayloadType()
    {
        return $this->defaultTelephonyEventPayloadType;
    }
    /**
     * Set defaultTelephonyEventPayloadType value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultTelephonyEventPayloadType
     * @return LSipProfile
     */
    public function setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($defaultTelephonyEventPayloadType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $defaultTelephonyEventPayloadType, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->defaultTelephonyEventPayloadType = $defaultTelephonyEventPayloadType;
        return $this;
    }
    /**
     * Get redirectByApplication value
     * @return string|null
     */
    public function getRedirectByApplication()
    {
        return $this->redirectByApplication;
    }
    /**
     * Set redirectByApplication value
     * @param string $redirectByApplication
     * @return LSipProfile
     */
    public function setRedirectByApplication($redirectByApplication = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectByApplication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectByApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectByApplication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectByApplication) && !is_string($redirectByApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectByApplication)), __LINE__);
        }
        $this->redirectByApplication = $redirectByApplication;
        return $this;
    }
    /**
     * Get ringing180 value
     * @return string|null
     */
    public function getRinging180()
    {
        return $this->ringing180;
    }
    /**
     * Set ringing180 value
     * @param string $ringing180
     * @return LSipProfile
     */
    public function setRinging180($ringing180 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ringing180) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ringing180)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ringing180, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ringing180) && !is_string($ringing180)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ringing180)), __LINE__);
        }
        $this->ringing180 = $ringing180;
        return $this;
    }
    /**
     * Get timerInvite value
     * @return string|null
     */
    public function getTimerInvite()
    {
        return $this->timerInvite;
    }
    /**
     * Set timerInvite value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerInvite
     * @return LSipProfile
     */
    public function setTimerInvite($timerInvite = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerInvite, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerInvite = $timerInvite;
        return $this;
    }
    /**
     * Get timerRegisterDelta value
     * @return string|null
     */
    public function getTimerRegisterDelta()
    {
        return $this->timerRegisterDelta;
    }
    /**
     * Set timerRegisterDelta value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerRegisterDelta
     * @return LSipProfile
     */
    public function setTimerRegisterDelta($timerRegisterDelta = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerRegisterDelta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerRegisterDelta, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerRegisterDelta = $timerRegisterDelta;
        return $this;
    }
    /**
     * Get timerRegister value
     * @return string|null
     */
    public function getTimerRegister()
    {
        return $this->timerRegister;
    }
    /**
     * Set timerRegister value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerRegister
     * @return LSipProfile
     */
    public function setTimerRegister($timerRegister = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerRegister)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerRegister, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerRegister = $timerRegister;
        return $this;
    }
    /**
     * Get timerT1 value
     * @return string|null
     */
    public function getTimerT1()
    {
        return $this->timerT1;
    }
    /**
     * Set timerT1 value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerT1
     * @return LSipProfile
     */
    public function setTimerT1($timerT1 = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerT1)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerT1, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerT1 = $timerT1;
        return $this;
    }
    /**
     * Get timerT2 value
     * @return string|null
     */
    public function getTimerT2()
    {
        return $this->timerT2;
    }
    /**
     * Set timerT2 value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerT2
     * @return LSipProfile
     */
    public function setTimerT2($timerT2 = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerT2)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerT2, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerT2 = $timerT2;
        return $this;
    }
    /**
     * Get retryInvite value
     * @return string|null
     */
    public function getRetryInvite()
    {
        return $this->retryInvite;
    }
    /**
     * Set retryInvite value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryInvite
     * @return LSipProfile
     */
    public function setRetryInvite($retryInvite = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($retryInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retryInvite, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->retryInvite = $retryInvite;
        return $this;
    }
    /**
     * Get retryNotInvite value
     * @return string|null
     */
    public function getRetryNotInvite()
    {
        return $this->retryNotInvite;
    }
    /**
     * Set retryNotInvite value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryNotInvite
     * @return LSipProfile
     */
    public function setRetryNotInvite($retryNotInvite = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($retryNotInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retryNotInvite, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->retryNotInvite = $retryNotInvite;
        return $this;
    }
    /**
     * Get startMediaPort value
     * @return string|null
     */
    public function getStartMediaPort()
    {
        return $this->startMediaPort;
    }
    /**
     * Set startMediaPort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startMediaPort
     * @return LSipProfile
     */
    public function setStartMediaPort($startMediaPort = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($startMediaPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startMediaPort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->startMediaPort = $startMediaPort;
        return $this;
    }
    /**
     * Get stopMediaPort value
     * @return string|null
     */
    public function getStopMediaPort()
    {
        return $this->stopMediaPort;
    }
    /**
     * Set stopMediaPort value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopMediaPort
     * @return LSipProfile
     */
    public function setStopMediaPort($stopMediaPort = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($stopMediaPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopMediaPort, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->stopMediaPort = $stopMediaPort;
        return $this;
    }
    /**
     * Get callpickupUri value
     * @return string|null
     */
    public function getCallpickupUri()
    {
        return $this->callpickupUri;
    }
    /**
     * Set callpickupUri value
     * @param string $callpickupUri
     * @return LSipProfile
     */
    public function setCallpickupUri($callpickupUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupUri) && strlen($callpickupUri) > 128) || (is_array($callpickupUri) && count($callpickupUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupUri) ? strlen($callpickupUri) : count($callpickupUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupUri) && !is_string($callpickupUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupUri)), __LINE__);
        }
        $this->callpickupUri = $callpickupUri;
        return $this;
    }
    /**
     * Get callpickupListUri value
     * @return string|null
     */
    public function getCallpickupListUri()
    {
        return $this->callpickupListUri;
    }
    /**
     * Set callpickupListUri value
     * @param string $callpickupListUri
     * @return LSipProfile
     */
    public function setCallpickupListUri($callpickupListUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupListUri) && strlen($callpickupListUri) > 128) || (is_array($callpickupListUri) && count($callpickupListUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupListUri) ? strlen($callpickupListUri) : count($callpickupListUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupListUri) && !is_string($callpickupListUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupListUri)), __LINE__);
        }
        $this->callpickupListUri = $callpickupListUri;
        return $this;
    }
    /**
     * Get callpickupGroupUri value
     * @return string|null
     */
    public function getCallpickupGroupUri()
    {
        return $this->callpickupGroupUri;
    }
    /**
     * Set callpickupGroupUri value
     * @param string $callpickupGroupUri
     * @return LSipProfile
     */
    public function setCallpickupGroupUri($callpickupGroupUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupGroupUri) && strlen($callpickupGroupUri) > 128) || (is_array($callpickupGroupUri) && count($callpickupGroupUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupGroupUri) ? strlen($callpickupGroupUri) : count($callpickupGroupUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupGroupUri) && !is_string($callpickupGroupUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupGroupUri)), __LINE__);
        }
        $this->callpickupGroupUri = $callpickupGroupUri;
        return $this;
    }
    /**
     * Get meetmeServiceUrl value
     * @return string|null
     */
    public function getMeetmeServiceUrl()
    {
        return $this->meetmeServiceUrl;
    }
    /**
     * Set meetmeServiceUrl value
     * @param string $meetmeServiceUrl
     * @return LSipProfile
     */
    public function setMeetmeServiceUrl($meetmeServiceUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($meetmeServiceUrl) && strlen($meetmeServiceUrl) > 128) || (is_array($meetmeServiceUrl) && count($meetmeServiceUrl) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($meetmeServiceUrl) ? strlen($meetmeServiceUrl) : count($meetmeServiceUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($meetmeServiceUrl) && !is_string($meetmeServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meetmeServiceUrl)), __LINE__);
        }
        $this->meetmeServiceUrl = $meetmeServiceUrl;
        return $this;
    }
    /**
     * Get userInfo value
     * @return string|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @uses XZzuserInfo::valueIsValid()
     * @uses XZzuserInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userInfo
     * @return LSipProfile
     */
    public function setUserInfo($userInfo = null)
    {
        // validation for constraint: enumeration
        if (!XZzuserInfo::valueIsValid($userInfo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userInfo, implode(', ', XZzuserInfo::getValidValues())), __LINE__);
        }
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return string|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @uses XZzdtmfDbLevel::valueIsValid()
     * @uses XZzdtmfDbLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfDbLevel
     * @return LSipProfile
     */
    public function setDtmfDbLevel($dtmfDbLevel = null)
    {
        // validation for constraint: enumeration
        if (!XZzdtmfDbLevel::valueIsValid($dtmfDbLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfDbLevel, implode(', ', XZzdtmfDbLevel::getValidValues())), __LINE__);
        }
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return string|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @uses XZzpreff::valueIsValid()
     * @uses XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callHoldRingback
     * @return LSipProfile
     */
    public function setCallHoldRingback($callHoldRingback = null)
    {
        // validation for constraint: enumeration
        if (!XZzpreff::valueIsValid($callHoldRingback)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callHoldRingback, implode(', ', XZzpreff::getValidValues())), __LINE__);
        }
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return string|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @uses XZzpreff::valueIsValid()
     * @uses XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anonymousCallBlock
     * @return LSipProfile
     */
    public function setAnonymousCallBlock($anonymousCallBlock = null)
    {
        // validation for constraint: enumeration
        if (!XZzpreff::valueIsValid($anonymousCallBlock)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $anonymousCallBlock, implode(', ', XZzpreff::getValidValues())), __LINE__);
        }
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return string|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @uses XZzpreff::valueIsValid()
     * @uses XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerIdBlock
     * @return LSipProfile
     */
    public function setCallerIdBlock($callerIdBlock = null)
    {
        // validation for constraint: enumeration
        if (!XZzpreff::valueIsValid($callerIdBlock)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callerIdBlock, implode(', ', XZzpreff::getValidValues())), __LINE__);
        }
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return string|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @uses XZzdndcontrol::valueIsValid()
     * @uses XZzdndcontrol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndControl
     * @return LSipProfile
     */
    public function setDndControl($dndControl = null)
    {
        // validation for constraint: enumeration
        if (!XZzdndcontrol::valueIsValid($dndControl)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndControl, implode(', ', XZzdndcontrol::getValidValues())), __LINE__);
        }
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return string|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @uses XTelnetLevel::valueIsValid()
     * @uses XTelnetLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $telnetLevel
     * @return LSipProfile
     */
    public function setTelnetLevel($telnetLevel = null)
    {
        // validation for constraint: enumeration
        if (!XTelnetLevel::valueIsValid($telnetLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $telnetLevel, implode(', ', XTelnetLevel::getValidValues())), __LINE__);
        }
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get timerKeepAlive value
     * @return string|null
     */
    public function getTimerKeepAlive()
    {
        return $this->timerKeepAlive;
    }
    /**
     * Set timerKeepAlive value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerKeepAlive
     * @return LSipProfile
     */
    public function setTimerKeepAlive($timerKeepAlive = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerKeepAlive, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerKeepAlive = $timerKeepAlive;
        return $this;
    }
    /**
     * Get timerSubscribe value
     * @return string|null
     */
    public function getTimerSubscribe()
    {
        return $this->timerSubscribe;
    }
    /**
     * Set timerSubscribe value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerSubscribe
     * @return LSipProfile
     */
    public function setTimerSubscribe($timerSubscribe = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerSubscribe)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerSubscribe, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerSubscribe = $timerSubscribe;
        return $this;
    }
    /**
     * Get timerSubscribeDelta value
     * @return string|null
     */
    public function getTimerSubscribeDelta()
    {
        return $this->timerSubscribeDelta;
    }
    /**
     * Set timerSubscribeDelta value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerSubscribeDelta
     * @return LSipProfile
     */
    public function setTimerSubscribeDelta($timerSubscribeDelta = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerSubscribeDelta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerSubscribeDelta, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerSubscribeDelta = $timerSubscribeDelta;
        return $this;
    }
    /**
     * Get maxRedirects value
     * @return string|null
     */
    public function getMaxRedirects()
    {
        return $this->maxRedirects;
    }
    /**
     * Set maxRedirects value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxRedirects
     * @return LSipProfile
     */
    public function setMaxRedirects($maxRedirects = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($maxRedirects)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxRedirects, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->maxRedirects = $maxRedirects;
        return $this;
    }
    /**
     * Get timerOffHookToFirstDigit value
     * @return string|null
     */
    public function getTimerOffHookToFirstDigit()
    {
        return $this->timerOffHookToFirstDigit;
    }
    /**
     * Set timerOffHookToFirstDigit value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerOffHookToFirstDigit
     * @return LSipProfile
     */
    public function setTimerOffHookToFirstDigit($timerOffHookToFirstDigit = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($timerOffHookToFirstDigit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerOffHookToFirstDigit, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->timerOffHookToFirstDigit = $timerOffHookToFirstDigit;
        return $this;
    }
    /**
     * Get callForwardUri value
     * @return string|null
     */
    public function getCallForwardUri()
    {
        return $this->callForwardUri;
    }
    /**
     * Set callForwardUri value
     * @param string $callForwardUri
     * @return LSipProfile
     */
    public function setCallForwardUri($callForwardUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callForwardUri) && strlen($callForwardUri) > 128) || (is_array($callForwardUri) && count($callForwardUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callForwardUri) ? strlen($callForwardUri) : count($callForwardUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callForwardUri) && !is_string($callForwardUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callForwardUri)), __LINE__);
        }
        $this->callForwardUri = $callForwardUri;
        return $this;
    }
    /**
     * Get abbreviatedDialUri value
     * @return string|null
     */
    public function getAbbreviatedDialUri()
    {
        return $this->abbreviatedDialUri;
    }
    /**
     * Set abbreviatedDialUri value
     * @param string $abbreviatedDialUri
     * @return LSipProfile
     */
    public function setAbbreviatedDialUri($abbreviatedDialUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abbreviatedDialUri) && strlen($abbreviatedDialUri) > 128) || (is_array($abbreviatedDialUri) && count($abbreviatedDialUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($abbreviatedDialUri) ? strlen($abbreviatedDialUri) : count($abbreviatedDialUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abbreviatedDialUri) && !is_string($abbreviatedDialUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviatedDialUri)), __LINE__);
        }
        $this->abbreviatedDialUri = $abbreviatedDialUri;
        return $this;
    }
    /**
     * Get confJointEnable value
     * @return string|null
     */
    public function getConfJointEnable()
    {
        return $this->confJointEnable;
    }
    /**
     * Set confJointEnable value
     * @param string $confJointEnable
     * @return LSipProfile
     */
    public function setConfJointEnable($confJointEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($confJointEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $confJointEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($confJointEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($confJointEnable) && !is_string($confJointEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confJointEnable)), __LINE__);
        }
        $this->confJointEnable = $confJointEnable;
        return $this;
    }
    /**
     * Get rfc2543Hold value
     * @return string|null
     */
    public function getRfc2543Hold()
    {
        return $this->rfc2543Hold;
    }
    /**
     * Set rfc2543Hold value
     * @param string $rfc2543Hold
     * @return LSipProfile
     */
    public function setRfc2543Hold($rfc2543Hold = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2543Hold) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2543Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2543Hold, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2543Hold) && !is_string($rfc2543Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2543Hold)), __LINE__);
        }
        $this->rfc2543Hold = $rfc2543Hold;
        return $this;
    }
    /**
     * Get semiAttendedTransfer value
     * @return string|null
     */
    public function getSemiAttendedTransfer()
    {
        return $this->semiAttendedTransfer;
    }
    /**
     * Set semiAttendedTransfer value
     * @param string $semiAttendedTransfer
     * @return LSipProfile
     */
    public function setSemiAttendedTransfer($semiAttendedTransfer = null)
    {
        // validation for constraint: pattern
        if (is_scalar($semiAttendedTransfer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $semiAttendedTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($semiAttendedTransfer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($semiAttendedTransfer) && !is_string($semiAttendedTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($semiAttendedTransfer)), __LINE__);
        }
        $this->semiAttendedTransfer = $semiAttendedTransfer;
        return $this;
    }
    /**
     * Get enableVad value
     * @return string|null
     */
    public function getEnableVad()
    {
        return $this->enableVad;
    }
    /**
     * Set enableVad value
     * @param string $enableVad
     * @return LSipProfile
     */
    public function setEnableVad($enableVad = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableVad) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableVad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableVad, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableVad) && !is_string($enableVad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableVad)), __LINE__);
        }
        $this->enableVad = $enableVad;
        return $this;
    }
    /**
     * Get stutterMsgWaiting value
     * @return string|null
     */
    public function getStutterMsgWaiting()
    {
        return $this->stutterMsgWaiting;
    }
    /**
     * Set stutterMsgWaiting value
     * @param string $stutterMsgWaiting
     * @return LSipProfile
     */
    public function setStutterMsgWaiting($stutterMsgWaiting = null)
    {
        // validation for constraint: pattern
        if (is_scalar($stutterMsgWaiting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $stutterMsgWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($stutterMsgWaiting, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stutterMsgWaiting) && !is_string($stutterMsgWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stutterMsgWaiting)), __LINE__);
        }
        $this->stutterMsgWaiting = $stutterMsgWaiting;
        return $this;
    }
    /**
     * Get callStats value
     * @return string|null
     */
    public function getCallStats()
    {
        return $this->callStats;
    }
    /**
     * Set callStats value
     * @param string $callStats
     * @return LSipProfile
     */
    public function setCallStats($callStats = null)
    {
        // validation for constraint: pattern
        if (is_scalar($callStats) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($callStats, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callStats) && !is_string($callStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callStats)), __LINE__);
        }
        $this->callStats = $callStats;
        return $this;
    }
    /**
     * Get t38Invite value
     * @return string|null
     */
    public function getT38Invite()
    {
        return $this->t38Invite;
    }
    /**
     * Set t38Invite value
     * @param string $t38Invite
     * @return LSipProfile
     */
    public function setT38Invite($t38Invite = null)
    {
        // validation for constraint: pattern
        if (is_scalar($t38Invite) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $t38Invite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($t38Invite, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($t38Invite) && !is_string($t38Invite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($t38Invite)), __LINE__);
        }
        $this->t38Invite = $t38Invite;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return string|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @uses XSIPReroute::valueIsValid()
     * @uses XSIPReroute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rerouteIncomingRequest
     * @return LSipProfile
     */
    public function setRerouteIncomingRequest($rerouteIncomingRequest = null)
    {
        // validation for constraint: enumeration
        if (!XSIPReroute::valueIsValid($rerouteIncomingRequest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rerouteIncomingRequest, implode(', ', XSIPReroute::getValidValues())), __LINE__);
        }
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * @return XFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return $this->resourcePriorityNamespaceListName;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * @param XFkType $resourcePriorityNamespaceListName
     * @return LSipProfile
     */
    public function setResourcePriorityNamespaceListName(XFkType $resourcePriorityNamespaceListName = null)
    {
        $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        return $this;
    }
    /**
     * Get enableAnatForEarlyOfferCalls value
     * @return string|null
     */
    public function getEnableAnatForEarlyOfferCalls()
    {
        return $this->enableAnatForEarlyOfferCalls;
    }
    /**
     * Set enableAnatForEarlyOfferCalls value
     * @param string $enableAnatForEarlyOfferCalls
     * @return LSipProfile
     */
    public function setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableAnatForEarlyOfferCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableAnatForEarlyOfferCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableAnatForEarlyOfferCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableAnatForEarlyOfferCalls) && !is_string($enableAnatForEarlyOfferCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableAnatForEarlyOfferCalls)), __LINE__);
        }
        $this->enableAnatForEarlyOfferCalls = $enableAnatForEarlyOfferCalls;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return string|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @uses XRSVPOverSIP::valueIsValid()
     * @uses XRSVPOverSIP::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpOverSip
     * @return LSipProfile
     */
    public function setRsvpOverSip($rsvpOverSip = null)
    {
        // validation for constraint: enumeration
        if (!XRSVPOverSIP::valueIsValid($rsvpOverSip)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rsvpOverSip, implode(', ', XRSVPOverSIP::getValidValues())), __LINE__);
        }
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get fallbackToLocalRsvp value
     * @return string|null
     */
    public function getFallbackToLocalRsvp()
    {
        return $this->fallbackToLocalRsvp;
    }
    /**
     * Set fallbackToLocalRsvp value
     * @param string $fallbackToLocalRsvp
     * @return LSipProfile
     */
    public function setFallbackToLocalRsvp($fallbackToLocalRsvp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($fallbackToLocalRsvp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $fallbackToLocalRsvp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($fallbackToLocalRsvp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fallbackToLocalRsvp) && !is_string($fallbackToLocalRsvp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fallbackToLocalRsvp)), __LINE__);
        }
        $this->fallbackToLocalRsvp = $fallbackToLocalRsvp;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return string|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @uses XSIPRel1XXOptions::valueIsValid()
     * @uses XSIPRel1XXOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipRe11XxEnabled
     * @return LSipProfile
     */
    public function setSipRe11XxEnabled($sipRe11XxEnabled = null)
    {
        // validation for constraint: enumeration
        if (!XSIPRel1XXOptions::valueIsValid($sipRe11XxEnabled)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipRe11XxEnabled, implode(', ', XSIPRel1XXOptions::getValidValues())), __LINE__);
        }
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return string|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @uses XGClear::valueIsValid()
     * @uses XGClear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gClear
     * @return LSipProfile
     */
    public function setGClear($gClear = null)
    {
        // validation for constraint: enumeration
        if (!XGClear::valueIsValid($gClear)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gClear, implode(', ', XGClear::getValidValues())), __LINE__);
        }
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get earlyOfferSupportForVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSupportForVoiceCall()
    {
        return $this->earlyOfferSupportForVoiceCall;
    }
    /**
     * Set earlyOfferSupportForVoiceCall value
     * @param string $earlyOfferSupportForVoiceCall
     * @return LSipProfile
     */
    public function setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($earlyOfferSupportForVoiceCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $earlyOfferSupportForVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($earlyOfferSupportForVoiceCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($earlyOfferSupportForVoiceCall) && !is_string($earlyOfferSupportForVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($earlyOfferSupportForVoiceCall)), __LINE__);
        }
        $this->earlyOfferSupportForVoiceCall = $earlyOfferSupportForVoiceCall;
        return $this;
    }
    /**
     * Get sendRecvSDPInMidCallInvite value
     * @return string|null
     */
    public function getSendRecvSDPInMidCallInvite()
    {
        return $this->sendRecvSDPInMidCallInvite;
    }
    /**
     * Set sendRecvSDPInMidCallInvite value
     * @param string $sendRecvSDPInMidCallInvite
     * @return LSipProfile
     */
    public function setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendRecvSDPInMidCallInvite) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendRecvSDPInMidCallInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendRecvSDPInMidCallInvite, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendRecvSDPInMidCallInvite) && !is_string($sendRecvSDPInMidCallInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendRecvSDPInMidCallInvite)), __LINE__);
        }
        $this->sendRecvSDPInMidCallInvite = $sendRecvSDPInMidCallInvite;
        return $this;
    }
    /**
     * Get enableOutboundOptionsPing value
     * @return string|null
     */
    public function getEnableOutboundOptionsPing()
    {
        return $this->enableOutboundOptionsPing;
    }
    /**
     * Set enableOutboundOptionsPing value
     * @param string $enableOutboundOptionsPing
     * @return LSipProfile
     */
    public function setEnableOutboundOptionsPing($enableOutboundOptionsPing = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableOutboundOptionsPing) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableOutboundOptionsPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableOutboundOptionsPing, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableOutboundOptionsPing) && !is_string($enableOutboundOptionsPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableOutboundOptionsPing)), __LINE__);
        }
        $this->enableOutboundOptionsPing = $enableOutboundOptionsPing;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusOK()
    {
        return $this->optionsPingIntervalWhenStatusOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusOK value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsPingIntervalWhenStatusOK
     * @return LSipProfile
     */
    public function setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($optionsPingIntervalWhenStatusOK)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optionsPingIntervalWhenStatusOK, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->optionsPingIntervalWhenStatusOK = $optionsPingIntervalWhenStatusOK;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusNotOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusNotOK()
    {
        return $this->optionsPingIntervalWhenStatusNotOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusNotOK value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @return LSipProfile
     */
    public function setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($optionsPingIntervalWhenStatusNotOK)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optionsPingIntervalWhenStatusNotOK, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->optionsPingIntervalWhenStatusNotOK = $optionsPingIntervalWhenStatusNotOK;
        return $this;
    }
    /**
     * Get deliverConferenceBridgeIdentifier value
     * @return string|null
     */
    public function getDeliverConferenceBridgeIdentifier()
    {
        return $this->deliverConferenceBridgeIdentifier;
    }
    /**
     * Set deliverConferenceBridgeIdentifier value
     * @param string $deliverConferenceBridgeIdentifier
     * @return LSipProfile
     */
    public function setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deliverConferenceBridgeIdentifier) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $deliverConferenceBridgeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($deliverConferenceBridgeIdentifier, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deliverConferenceBridgeIdentifier) && !is_string($deliverConferenceBridgeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliverConferenceBridgeIdentifier)), __LINE__);
        }
        $this->deliverConferenceBridgeIdentifier = $deliverConferenceBridgeIdentifier;
        return $this;
    }
    /**
     * Get sipOptionsRetryCount value
     * @return string|null
     */
    public function getSipOptionsRetryCount()
    {
        return $this->sipOptionsRetryCount;
    }
    /**
     * Set sipOptionsRetryCount value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipOptionsRetryCount
     * @return LSipProfile
     */
    public function setSipOptionsRetryCount($sipOptionsRetryCount = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sipOptionsRetryCount)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipOptionsRetryCount, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->sipOptionsRetryCount = $sipOptionsRetryCount;
        return $this;
    }
    /**
     * Get sipOptionsRetryTimer value
     * @return string|null
     */
    public function getSipOptionsRetryTimer()
    {
        return $this->sipOptionsRetryTimer;
    }
    /**
     * Set sipOptionsRetryTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipOptionsRetryTimer
     * @return LSipProfile
     */
    public function setSipOptionsRetryTimer($sipOptionsRetryTimer = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($sipOptionsRetryTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipOptionsRetryTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->sipOptionsRetryTimer = $sipOptionsRetryTimer;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return string|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @uses XSIPBandwidthModifier::valueIsValid()
     * @uses XSIPBandwidthModifier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipBandwidthModifier
     * @return LSipProfile
     */
    public function setSipBandwidthModifier($sipBandwidthModifier = null)
    {
        // validation for constraint: enumeration
        if (!XSIPBandwidthModifier::valueIsValid($sipBandwidthModifier)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipBandwidthModifier, implode(', ', XSIPBandwidthModifier::getValidValues())), __LINE__);
        }
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get enableUriOutdialSupport value
     * @return string|null
     */
    public function getEnableUriOutdialSupport()
    {
        return $this->enableUriOutdialSupport;
    }
    /**
     * Set enableUriOutdialSupport value
     * @param string $enableUriOutdialSupport
     * @return LSipProfile
     */
    public function setEnableUriOutdialSupport($enableUriOutdialSupport = null)
    {
        // validation for constraint: string
        if (!is_null($enableUriOutdialSupport) && !is_string($enableUriOutdialSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableUriOutdialSupport)), __LINE__);
        }
        $this->enableUriOutdialSupport = $enableUriOutdialSupport;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return string|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @uses XUserAgentServerHeaderInfo::valueIsValid()
     * @uses XUserAgentServerHeaderInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userAgentServerHeaderInfo
     * @return LSipProfile
     */
    public function setUserAgentServerHeaderInfo($userAgentServerHeaderInfo = null)
    {
        // validation for constraint: enumeration
        if (!XUserAgentServerHeaderInfo::valueIsValid($userAgentServerHeaderInfo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userAgentServerHeaderInfo, implode(', ', XUserAgentServerHeaderInfo::getValidValues())), __LINE__);
        }
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get allowPresentationSharingUsingBfcp value
     * @return string|null
     */
    public function getAllowPresentationSharingUsingBfcp()
    {
        return $this->allowPresentationSharingUsingBfcp;
    }
    /**
     * Set allowPresentationSharingUsingBfcp value
     * @param string $allowPresentationSharingUsingBfcp
     * @return LSipProfile
     */
    public function setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowPresentationSharingUsingBfcp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowPresentationSharingUsingBfcp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowPresentationSharingUsingBfcp) && !is_string($allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowPresentationSharingUsingBfcp)), __LINE__);
        }
        $this->allowPresentationSharingUsingBfcp = $allowPresentationSharingUsingBfcp;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return LSipProfile
     */
    public function setScriptParameters($scriptParameters = null)
    {
        // validation for constraint: string
        if (!is_null($scriptParameters) && !is_string($scriptParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scriptParameters)), __LINE__);
        }
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get isScriptTraceEnabled value
     * @return string|null
     */
    public function getIsScriptTraceEnabled()
    {
        return $this->isScriptTraceEnabled;
    }
    /**
     * Set isScriptTraceEnabled value
     * @param string $isScriptTraceEnabled
     * @return LSipProfile
     */
    public function setIsScriptTraceEnabled($isScriptTraceEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isScriptTraceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isScriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isScriptTraceEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isScriptTraceEnabled) && !is_string($isScriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isScriptTraceEnabled)), __LINE__);
        }
        $this->isScriptTraceEnabled = $isScriptTraceEnabled;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * @return XFkType|null
     */
    public function getSipNormalizationScript()
    {
        return $this->sipNormalizationScript;
    }
    /**
     * Set sipNormalizationScript value
     * @param XFkType $sipNormalizationScript
     * @return LSipProfile
     */
    public function setSipNormalizationScript(XFkType $sipNormalizationScript = null)
    {
        $this->sipNormalizationScript = $sipNormalizationScript;
        return $this;
    }
    /**
     * Get allowiXApplicationMedia value
     * @return string|null
     */
    public function getAllowiXApplicationMedia()
    {
        return $this->allowiXApplicationMedia;
    }
    /**
     * Set allowiXApplicationMedia value
     * @param string $allowiXApplicationMedia
     * @return LSipProfile
     */
    public function setAllowiXApplicationMedia($allowiXApplicationMedia = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowiXApplicationMedia) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowiXApplicationMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowiXApplicationMedia, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowiXApplicationMedia) && !is_string($allowiXApplicationMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowiXApplicationMedia)), __LINE__);
        }
        $this->allowiXApplicationMedia = $allowiXApplicationMedia;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return string|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @uses XURIDisambiguationPolicy::valueIsValid()
     * @uses XURIDisambiguationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialStringInterpretation
     * @return LSipProfile
     */
    public function setDialStringInterpretation($dialStringInterpretation = null)
    {
        // validation for constraint: enumeration
        if (!XURIDisambiguationPolicy::valueIsValid($dialStringInterpretation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialStringInterpretation, implode(', ', XURIDisambiguationPolicy::getValidValues())), __LINE__);
        }
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return string|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptAudioCodecPreferences
     * @return LSipProfile
     */
    public function setAcceptAudioCodecPreferences($acceptAudioCodecPreferences = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($acceptAudioCodecPreferences)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $acceptAudioCodecPreferences, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get mlppUserAuthorization value
     * @return string|null
     */
    public function getMlppUserAuthorization()
    {
        return $this->mlppUserAuthorization;
    }
    /**
     * Set mlppUserAuthorization value
     * @param string $mlppUserAuthorization
     * @return LSipProfile
     */
    public function setMlppUserAuthorization($mlppUserAuthorization = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mlppUserAuthorization) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mlppUserAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mlppUserAuthorization, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppUserAuthorization) && !is_string($mlppUserAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppUserAuthorization)), __LINE__);
        }
        $this->mlppUserAuthorization = $mlppUserAuthorization;
        return $this;
    }
    /**
     * Get isAssuredSipServiceEnabled value
     * @return string|null
     */
    public function getIsAssuredSipServiceEnabled()
    {
        return $this->isAssuredSipServiceEnabled;
    }
    /**
     * Set isAssuredSipServiceEnabled value
     * @param string $isAssuredSipServiceEnabled
     * @return LSipProfile
     */
    public function setIsAssuredSipServiceEnabled($isAssuredSipServiceEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isAssuredSipServiceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isAssuredSipServiceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isAssuredSipServiceEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isAssuredSipServiceEnabled) && !is_string($isAssuredSipServiceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isAssuredSipServiceEnabled)), __LINE__);
        }
        $this->isAssuredSipServiceEnabled = $isAssuredSipServiceEnabled;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * @return XFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return $this->resourcePriorityNamespace;
    }
    /**
     * Set resourcePriorityNamespace value
     * @param XFkType $resourcePriorityNamespace
     * @return LSipProfile
     */
    public function setResourcePriorityNamespace(XFkType $resourcePriorityNamespace = null)
    {
        $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        return $this;
    }
    /**
     * Get useCallerIdCallerNameinUriOutgoingRequest value
     * @return string|null
     */
    public function getUseCallerIdCallerNameinUriOutgoingRequest()
    {
        return $this->useCallerIdCallerNameinUriOutgoingRequest;
    }
    /**
     * Set useCallerIdCallerNameinUriOutgoingRequest value
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @return LSipProfile
     */
    public function setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useCallerIdCallerNameinUriOutgoingRequest) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useCallerIdCallerNameinUriOutgoingRequest, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useCallerIdCallerNameinUriOutgoingRequest) && !is_string($useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCallerIdCallerNameinUriOutgoingRequest)), __LINE__);
        }
        $this->useCallerIdCallerNameinUriOutgoingRequest = $useCallerIdCallerNameinUriOutgoingRequest;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return LSipProfile
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 50) || (is_array($callerIdDn) && count($callerIdDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return LSipProfile
     */
    public function setCallerName($callerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerName) && strlen($callerName) > 50) || (is_array($callerName) && count($callerName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerName) ? strlen($callerName) : count($callerName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerName)), __LINE__);
        }
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return string|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @uses XCallingLineIdentification::valueIsValid()
     * @uses XCallingLineIdentification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdentification
     * @return LSipProfile
     */
    public function setCallingLineIdentification($callingLineIdentification = null)
    {
        // validation for constraint: enumeration
        if (!XCallingLineIdentification::valueIsValid($callingLineIdentification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLineIdentification, implode(', ', XCallingLineIdentification::getValidValues())), __LINE__);
        }
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get rejectAnonymousIncomingCall value
     * @return string|null
     */
    public function getRejectAnonymousIncomingCall()
    {
        return $this->rejectAnonymousIncomingCall;
    }
    /**
     * Set rejectAnonymousIncomingCall value
     * @param string $rejectAnonymousIncomingCall
     * @return LSipProfile
     */
    public function setRejectAnonymousIncomingCall($rejectAnonymousIncomingCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejectAnonymousIncomingCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousIncomingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rejectAnonymousIncomingCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rejectAnonymousIncomingCall) && !is_string($rejectAnonymousIncomingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rejectAnonymousIncomingCall)), __LINE__);
        }
        $this->rejectAnonymousIncomingCall = $rejectAnonymousIncomingCall;
        return $this;
    }
    /**
     * Get rejectAnonymousOutgoingCall value
     * @return string|null
     */
    public function getRejectAnonymousOutgoingCall()
    {
        return $this->rejectAnonymousOutgoingCall;
    }
    /**
     * Set rejectAnonymousOutgoingCall value
     * @param string $rejectAnonymousOutgoingCall
     * @return LSipProfile
     */
    public function setRejectAnonymousOutgoingCall($rejectAnonymousOutgoingCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejectAnonymousOutgoingCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousOutgoingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rejectAnonymousOutgoingCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rejectAnonymousOutgoingCall) && !is_string($rejectAnonymousOutgoingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rejectAnonymousOutgoingCall)), __LINE__);
        }
        $this->rejectAnonymousOutgoingCall = $rejectAnonymousOutgoingCall;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return string|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @uses XVideoCallTrafficClass::valueIsValid()
     * @uses XVideoCallTrafficClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoCallTrafficClass
     * @return LSipProfile
     */
    public function setVideoCallTrafficClass($videoCallTrafficClass = null)
    {
        // validation for constraint: enumeration
        if (!XVideoCallTrafficClass::valueIsValid($videoCallTrafficClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoCallTrafficClass, implode(', ', XVideoCallTrafficClass::getValidValues())), __LINE__);
        }
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LSipProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LSipProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
