<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LResourcePriorityNamespace StructType
 * @subpackage Structs
 */
class LResourcePriorityNamespace extends AbstractStructBase
{
    /**
     * The namespace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $namespace;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LResourcePriorityNamespace
     * @uses LResourcePriorityNamespace::setNamespace()
     * @uses LResourcePriorityNamespace::setDescription()
     * @uses LResourcePriorityNamespace::setUuid()
     * @param string $namespace
     * @param string $description
     * @param string $uuid
     */
    public function __construct($namespace = null, $description = null, $uuid = null)
    {
        $this
            ->setNamespace($namespace)
            ->setDescription($description)
            ->setUuid($uuid);
    }
    /**
     * Get namespace value
     * @return string|null
     */
    public function getNamespace()
    {
        return $this->namespace;
    }
    /**
     * Set namespace value
     * @param string $namespace
     * @return LResourcePriorityNamespace
     */
    public function setNamespace($namespace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($namespace) && strlen($namespace) > 10) || (is_array($namespace) && count($namespace) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($namespace) ? strlen($namespace) : count($namespace)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($namespace) && !is_string($namespace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($namespace)), __LINE__);
        }
        $this->namespace = $namespace;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LResourcePriorityNamespace
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LResourcePriorityNamespace
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LResourcePriorityNamespace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
