<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRegionMatrix StructType
 * @subpackage Structs
 */
class LRegionMatrix extends AbstractStructBase
{
    /**
     * The bandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoBandwidth;
    /**
     * The lossyNetwork
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lossyNetwork;
    /**
     * The regionAName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $regionAName;
    /**
     * The regionBName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $regionBName;
    /**
     * The codecPreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $codecPreference;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRegionMatrix
     * @uses LRegionMatrix::setBandwidth()
     * @uses LRegionMatrix::setVideoBandwidth()
     * @uses LRegionMatrix::setLossyNetwork()
     * @uses LRegionMatrix::setRegionAName()
     * @uses LRegionMatrix::setRegionBName()
     * @uses LRegionMatrix::setCodecPreference()
     * @uses LRegionMatrix::setUuid()
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param string $lossyNetwork
     * @param XFkType $regionAName
     * @param XFkType $regionBName
     * @param XFkType $codecPreference
     * @param string $uuid
     */
    public function __construct($bandwidth = null, $videoBandwidth = null, $lossyNetwork = null, XFkType $regionAName = null, XFkType $regionBName = null, XFkType $codecPreference = null, $uuid = null)
    {
        $this
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setLossyNetwork($lossyNetwork)
            ->setRegionAName($regionAName)
            ->setRegionBName($regionBName)
            ->setCodecPreference($codecPreference)
            ->setUuid($uuid);
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @uses XBandwidth::valueIsValid()
     * @uses XBandwidth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bandwidth
     * @return LRegionMatrix
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: enumeration
        if (!XBandwidth::valueIsValid($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bandwidth, implode(', ', XBandwidth::getValidValues())), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return LRegionMatrix
     */
    public function setVideoBandwidth($videoBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get lossyNetwork value
     * @return string|null
     */
    public function getLossyNetwork()
    {
        return $this->lossyNetwork;
    }
    /**
     * Set lossyNetwork value
     * @uses XLossyNetwork::valueIsValid()
     * @uses XLossyNetwork::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lossyNetwork
     * @return LRegionMatrix
     */
    public function setLossyNetwork($lossyNetwork = null)
    {
        // validation for constraint: enumeration
        if (!XLossyNetwork::valueIsValid($lossyNetwork)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lossyNetwork, implode(', ', XLossyNetwork::getValidValues())), __LINE__);
        }
        $this->lossyNetwork = $lossyNetwork;
        return $this;
    }
    /**
     * Get regionAName value
     * @return XFkType|null
     */
    public function getRegionAName()
    {
        return $this->regionAName;
    }
    /**
     * Set regionAName value
     * @param XFkType $regionAName
     * @return LRegionMatrix
     */
    public function setRegionAName(XFkType $regionAName = null)
    {
        $this->regionAName = $regionAName;
        return $this;
    }
    /**
     * Get regionBName value
     * @return XFkType|null
     */
    public function getRegionBName()
    {
        return $this->regionBName;
    }
    /**
     * Set regionBName value
     * @param XFkType $regionBName
     * @return LRegionMatrix
     */
    public function setRegionBName(XFkType $regionBName = null)
    {
        $this->regionBName = $regionBName;
        return $this;
    }
    /**
     * Get codecPreference value
     * @return XFkType|null
     */
    public function getCodecPreference()
    {
        return $this->codecPreference;
    }
    /**
     * Set codecPreference value
     * @param XFkType $codecPreference
     * @return LRegionMatrix
     */
    public function setCodecPreference(XFkType $codecPreference = null)
    {
        $this->codecPreference = $codecPreference;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LRegionMatrix
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LRegionMatrix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
