<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLocationBetween StructType
 * @subpackage Structs
 */
class LLocationBetween extends AbstractStructBase
{
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $locationName;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $weight;
    /**
     * The audioBandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audioBandwidth;
    /**
     * The videoBandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $videoBandwidth;
    /**
     * The immersiveBandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $immersiveBandwidth;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLocationBetween
     * @uses LLocationBetween::setLocationName()
     * @uses LLocationBetween::setWeight()
     * @uses LLocationBetween::setAudioBandwidth()
     * @uses LLocationBetween::setVideoBandwidth()
     * @uses LLocationBetween::setImmersiveBandwidth()
     * @uses LLocationBetween::setUuid()
     * @param XFkType $locationName
     * @param string $weight
     * @param string $audioBandwidth
     * @param string $videoBandwidth
     * @param string $immersiveBandwidth
     * @param string $uuid
     */
    public function __construct(XFkType $locationName = null, $weight = null, $audioBandwidth = null, $videoBandwidth = null, $immersiveBandwidth = null, $uuid = null)
    {
        $this
            ->setLocationName($locationName)
            ->setWeight($weight)
            ->setAudioBandwidth($audioBandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setImmersiveBandwidth($immersiveBandwidth)
            ->setUuid($uuid);
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return LLocationBetween
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $weight
     * @return LLocationBetween
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($weight)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $weight, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get audioBandwidth value
     * @return string|null
     */
    public function getAudioBandwidth()
    {
        return $this->audioBandwidth;
    }
    /**
     * Set audioBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audioBandwidth
     * @return LLocationBetween
     */
    public function setAudioBandwidth($audioBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($audioBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audioBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->audioBandwidth = $audioBandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return LLocationBetween
     */
    public function setVideoBandwidth($videoBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get immersiveBandwidth value
     * @return string|null
     */
    public function getImmersiveBandwidth()
    {
        return $this->immersiveBandwidth;
    }
    /**
     * Set immersiveBandwidth value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $immersiveBandwidth
     * @return LLocationBetween
     */
    public function setImmersiveBandwidth($immersiveBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($immersiveBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $immersiveBandwidth, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->immersiveBandwidth = $immersiveBandwidth;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LLocationBetween
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LLocationBetween
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
