<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LGatewayEndpointDigitalAccessPri StructType
 * @subpackage Structs
 */
class LGatewayEndpointDigitalAccessPri extends AbstractStructBase
{
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * The subunit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subunit;
    /**
     * The endpoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LGatewayEndpointDigitalPri
     */
    public $endpoint;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LGatewayEndpointDigitalAccessPri
     * @uses LGatewayEndpointDigitalAccessPri::setDomainName()
     * @uses LGatewayEndpointDigitalAccessPri::setGatewayUuid()
     * @uses LGatewayEndpointDigitalAccessPri::setUnit()
     * @uses LGatewayEndpointDigitalAccessPri::setSubunit()
     * @uses LGatewayEndpointDigitalAccessPri::setEndpoint()
     * @uses LGatewayEndpointDigitalAccessPri::setUuid()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param string $unit
     * @param string $subunit
     * @param LGatewayEndpointDigitalPri $endpoint
     * @param string $uuid
     */
    public function __construct($domainName = null, $gatewayUuid = null, $unit = null, $subunit = null, LGatewayEndpointDigitalPri $endpoint = null, $uuid = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUnit($unit)
            ->setSubunit($subunit)
            ->setEndpoint($endpoint)
            ->setUuid($uuid);
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return LGatewayEndpointDigitalAccessPri
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string|null
     */
    public function getGatewayUuid()
    {
        return $this->gatewayUuid;
    }
    /**
     * Set gatewayUuid value
     * @param string $gatewayUuid
     * @return LGatewayEndpointDigitalAccessPri
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gatewayUuid) && !preg_match('/\{........-....-....-....-............\}/', $gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($gatewayUuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gatewayUuid) && !is_string($gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gatewayUuid)), __LINE__);
        }
        $this->gatewayUuid = $gatewayUuid;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit
     * @return LGatewayEndpointDigitalAccessPri
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($unit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unit, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get subunit value
     * @return string|null
     */
    public function getSubunit()
    {
        return $this->subunit;
    }
    /**
     * Set subunit value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subunit
     * @return LGatewayEndpointDigitalAccessPri
     */
    public function setSubunit($subunit = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($subunit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subunit, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->subunit = $subunit;
        return $this;
    }
    /**
     * Get endpoint value
     * @return LGatewayEndpointDigitalPri|null
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }
    /**
     * Set endpoint value
     * @param LGatewayEndpointDigitalPri $endpoint
     * @return LGatewayEndpointDigitalAccessPri
     */
    public function setEndpoint(LGatewayEndpointDigitalPri $endpoint = null)
    {
        $this->endpoint = $endpoint;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LGatewayEndpointDigitalAccessPri
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LGatewayEndpointDigitalAccessPri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
