<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCredentialPolicy StructType
 * @subpackage Structs
 */
class LCredentialPolicy extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The failedLogon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $failedLogon;
    /**
     * The resetFailedLogonAttempts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $resetFailedLogonAttempts;
    /**
     * The lockoutDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lockoutDuration;
    /**
     * The credChangeDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credChangeDuration;
    /**
     * The credExpiresAfter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $credExpiresAfter;
    /**
     * The minCredLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $minCredLength;
    /**
     * The prevCredStoredNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prevCredStoredNum;
    /**
     * The inactiveDaysAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $inactiveDaysAllowed;
    /**
     * The expiryWarningDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $expiryWarningDays;
    /**
     * The trivialCredCheck
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trivialCredCheck;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCredentialPolicy
     * @uses LCredentialPolicy::setName()
     * @uses LCredentialPolicy::setFailedLogon()
     * @uses LCredentialPolicy::setResetFailedLogonAttempts()
     * @uses LCredentialPolicy::setLockoutDuration()
     * @uses LCredentialPolicy::setCredChangeDuration()
     * @uses LCredentialPolicy::setCredExpiresAfter()
     * @uses LCredentialPolicy::setMinCredLength()
     * @uses LCredentialPolicy::setPrevCredStoredNum()
     * @uses LCredentialPolicy::setInactiveDaysAllowed()
     * @uses LCredentialPolicy::setExpiryWarningDays()
     * @uses LCredentialPolicy::setTrivialCredCheck()
     * @uses LCredentialPolicy::setUuid()
     * @param string $name
     * @param string $failedLogon
     * @param string $resetFailedLogonAttempts
     * @param string $lockoutDuration
     * @param string $credChangeDuration
     * @param string $credExpiresAfter
     * @param string $minCredLength
     * @param string $prevCredStoredNum
     * @param string $inactiveDaysAllowed
     * @param string $expiryWarningDays
     * @param string $trivialCredCheck
     * @param string $uuid
     */
    public function __construct($name = null, $failedLogon = null, $resetFailedLogonAttempts = null, $lockoutDuration = null, $credChangeDuration = null, $credExpiresAfter = null, $minCredLength = null, $prevCredStoredNum = null, $inactiveDaysAllowed = null, $expiryWarningDays = null, $trivialCredCheck = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setFailedLogon($failedLogon)
            ->setResetFailedLogonAttempts($resetFailedLogonAttempts)
            ->setLockoutDuration($lockoutDuration)
            ->setCredChangeDuration($credChangeDuration)
            ->setCredExpiresAfter($credExpiresAfter)
            ->setMinCredLength($minCredLength)
            ->setPrevCredStoredNum($prevCredStoredNum)
            ->setInactiveDaysAllowed($inactiveDaysAllowed)
            ->setExpiryWarningDays($expiryWarningDays)
            ->setTrivialCredCheck($trivialCredCheck)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LCredentialPolicy
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get failedLogon value
     * @return string|null
     */
    public function getFailedLogon()
    {
        return $this->failedLogon;
    }
    /**
     * Set failedLogon value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failedLogon
     * @return LCredentialPolicy
     */
    public function setFailedLogon($failedLogon = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($failedLogon)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $failedLogon, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->failedLogon = $failedLogon;
        return $this;
    }
    /**
     * Get resetFailedLogonAttempts value
     * @return string|null
     */
    public function getResetFailedLogonAttempts()
    {
        return $this->resetFailedLogonAttempts;
    }
    /**
     * Set resetFailedLogonAttempts value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resetFailedLogonAttempts
     * @return LCredentialPolicy
     */
    public function setResetFailedLogonAttempts($resetFailedLogonAttempts = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($resetFailedLogonAttempts)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resetFailedLogonAttempts, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->resetFailedLogonAttempts = $resetFailedLogonAttempts;
        return $this;
    }
    /**
     * Get lockoutDuration value
     * @return string|null
     */
    public function getLockoutDuration()
    {
        return $this->lockoutDuration;
    }
    /**
     * Set lockoutDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lockoutDuration
     * @return LCredentialPolicy
     */
    public function setLockoutDuration($lockoutDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($lockoutDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lockoutDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->lockoutDuration = $lockoutDuration;
        return $this;
    }
    /**
     * Get credChangeDuration value
     * @return string|null
     */
    public function getCredChangeDuration()
    {
        return $this->credChangeDuration;
    }
    /**
     * Set credChangeDuration value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credChangeDuration
     * @return LCredentialPolicy
     */
    public function setCredChangeDuration($credChangeDuration = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($credChangeDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credChangeDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->credChangeDuration = $credChangeDuration;
        return $this;
    }
    /**
     * Get credExpiresAfter value
     * @return string|null
     */
    public function getCredExpiresAfter()
    {
        return $this->credExpiresAfter;
    }
    /**
     * Set credExpiresAfter value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credExpiresAfter
     * @return LCredentialPolicy
     */
    public function setCredExpiresAfter($credExpiresAfter = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($credExpiresAfter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credExpiresAfter, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->credExpiresAfter = $credExpiresAfter;
        return $this;
    }
    /**
     * Get minCredLength value
     * @return string|null
     */
    public function getMinCredLength()
    {
        return $this->minCredLength;
    }
    /**
     * Set minCredLength value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $minCredLength
     * @return LCredentialPolicy
     */
    public function setMinCredLength($minCredLength = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($minCredLength)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $minCredLength, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->minCredLength = $minCredLength;
        return $this;
    }
    /**
     * Get prevCredStoredNum value
     * @return string|null
     */
    public function getPrevCredStoredNum()
    {
        return $this->prevCredStoredNum;
    }
    /**
     * Set prevCredStoredNum value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $prevCredStoredNum
     * @return LCredentialPolicy
     */
    public function setPrevCredStoredNum($prevCredStoredNum = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($prevCredStoredNum)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $prevCredStoredNum, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->prevCredStoredNum = $prevCredStoredNum;
        return $this;
    }
    /**
     * Get inactiveDaysAllowed value
     * @return string|null
     */
    public function getInactiveDaysAllowed()
    {
        return $this->inactiveDaysAllowed;
    }
    /**
     * Set inactiveDaysAllowed value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inactiveDaysAllowed
     * @return LCredentialPolicy
     */
    public function setInactiveDaysAllowed($inactiveDaysAllowed = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($inactiveDaysAllowed)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $inactiveDaysAllowed, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->inactiveDaysAllowed = $inactiveDaysAllowed;
        return $this;
    }
    /**
     * Get expiryWarningDays value
     * @return string|null
     */
    public function getExpiryWarningDays()
    {
        return $this->expiryWarningDays;
    }
    /**
     * Set expiryWarningDays value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expiryWarningDays
     * @return LCredentialPolicy
     */
    public function setExpiryWarningDays($expiryWarningDays = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($expiryWarningDays)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $expiryWarningDays, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->expiryWarningDays = $expiryWarningDays;
        return $this;
    }
    /**
     * Get trivialCredCheck value
     * @return string|null
     */
    public function getTrivialCredCheck()
    {
        return $this->trivialCredCheck;
    }
    /**
     * Set trivialCredCheck value
     * @param string $trivialCredCheck
     * @return LCredentialPolicy
     */
    public function setTrivialCredCheck($trivialCredCheck = null)
    {
        // validation for constraint: pattern
        if (is_scalar($trivialCredCheck) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $trivialCredCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($trivialCredCheck, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($trivialCredCheck) && !is_string($trivialCredCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trivialCredCheck)), __LINE__);
        }
        $this->trivialCredCheck = $trivialCredCheck;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LCredentialPolicy
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LCredentialPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
