<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCommonPhoneConfig StructType
 * @subpackage Structs
 */
class LCommonPhoneConfig extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndAlertingType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndAlertingType;
    /**
     * The backgroundImage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $backgroundImage;
    /**
     * The phonePersonalization
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phonePersonalization;
    /**
     * The phoneServiceDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The sshUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $sshUserId;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The vpnGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $vpnGroupName;
    /**
     * The vpnProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $vpnProfileName;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $featureControlPolicy;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCommonPhoneConfig
     * @uses LCommonPhoneConfig::setName()
     * @uses LCommonPhoneConfig::setDescription()
     * @uses LCommonPhoneConfig::setDndOption()
     * @uses LCommonPhoneConfig::setDndAlertingType()
     * @uses LCommonPhoneConfig::setBackgroundImage()
     * @uses LCommonPhoneConfig::setPhonePersonalization()
     * @uses LCommonPhoneConfig::setPhoneServiceDisplay()
     * @uses LCommonPhoneConfig::setSshUserId()
     * @uses LCommonPhoneConfig::setAlwaysUsePrimeLine()
     * @uses LCommonPhoneConfig::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses LCommonPhoneConfig::setVpnGroupName()
     * @uses LCommonPhoneConfig::setVpnProfileName()
     * @uses LCommonPhoneConfig::setFeatureControlPolicy()
     * @uses LCommonPhoneConfig::setUuid()
     * @param string $name
     * @param string $description
     * @param string $dndOption
     * @param string $dndAlertingType
     * @param string $backgroundImage
     * @param string $phonePersonalization
     * @param string $phoneServiceDisplay
     * @param string $sshUserId
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param XFkType $vpnGroupName
     * @param XFkType $vpnProfileName
     * @param XFkType $featureControlPolicy
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $dndOption = null, $dndAlertingType = null, $backgroundImage = null, $phonePersonalization = null, $phoneServiceDisplay = null, $sshUserId = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, XFkType $vpnGroupName = null, XFkType $vpnProfileName = null, XFkType $featureControlPolicy = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDndOption($dndOption)
            ->setDndAlertingType($dndAlertingType)
            ->setBackgroundImage($backgroundImage)
            ->setPhonePersonalization($phonePersonalization)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setSshUserId($sshUserId)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setVpnGroupName($vpnGroupName)
            ->setVpnProfileName($vpnProfileName)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LCommonPhoneConfig
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LCommonPhoneConfig
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses XDNDOption::valueIsValid()
     * @uses XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return LCommonPhoneConfig
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndAlertingType value
     * @return string|null
     */
    public function getDndAlertingType()
    {
        return $this->dndAlertingType;
    }
    /**
     * Set dndAlertingType value
     * @uses XRingSetting::valueIsValid()
     * @uses XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndAlertingType
     * @return LCommonPhoneConfig
     */
    public function setDndAlertingType($dndAlertingType = null)
    {
        // validation for constraint: enumeration
        if (!XRingSetting::valueIsValid($dndAlertingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndAlertingType, implode(', ', XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndAlertingType = $dndAlertingType;
        return $this;
    }
    /**
     * Get backgroundImage value
     * @return string|null
     */
    public function getBackgroundImage()
    {
        return $this->backgroundImage;
    }
    /**
     * Set backgroundImage value
     * @param string $backgroundImage
     * @return LCommonPhoneConfig
     */
    public function setBackgroundImage($backgroundImage = null)
    {
        // validation for constraint: pattern
        if (is_scalar($backgroundImage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $backgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($backgroundImage, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($backgroundImage) && !is_string($backgroundImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($backgroundImage)), __LINE__);
        }
        $this->backgroundImage = $backgroundImage;
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string|null
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @uses XPhonePersonalization::valueIsValid()
     * @uses XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phonePersonalization
     * @return LCommonPhoneConfig
     */
    public function setPhonePersonalization($phonePersonalization = null)
    {
        // validation for constraint: enumeration
        if (!XPhonePersonalization::valueIsValid($phonePersonalization)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phonePersonalization, implode(', ', XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @uses XPhoneServiceDisplay::valueIsValid()
     * @uses XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneServiceDisplay
     * @return LCommonPhoneConfig
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = null)
    {
        // validation for constraint: enumeration
        if (!XPhoneServiceDisplay::valueIsValid($phoneServiceDisplay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneServiceDisplay, implode(', ', XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return LCommonPhoneConfig
     */
    public function setSshUserId($sshUserId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sshUserId) && strlen($sshUserId) > 50) || (is_array($sshUserId) && count($sshUserId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($sshUserId) ? strlen($sshUserId) : count($sshUserId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sshUserId) && !is_string($sshUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sshUserId)), __LINE__);
        }
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return LCommonPhoneConfig
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return LCommonPhoneConfig
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get vpnGroupName value
     * @return XFkType|null
     */
    public function getVpnGroupName()
    {
        return $this->vpnGroupName;
    }
    /**
     * Set vpnGroupName value
     * @param XFkType $vpnGroupName
     * @return LCommonPhoneConfig
     */
    public function setVpnGroupName(XFkType $vpnGroupName = null)
    {
        $this->vpnGroupName = $vpnGroupName;
        return $this;
    }
    /**
     * Get vpnProfileName value
     * @return XFkType|null
     */
    public function getVpnProfileName()
    {
        return $this->vpnProfileName;
    }
    /**
     * Set vpnProfileName value
     * @param XFkType $vpnProfileName
     * @return LCommonPhoneConfig
     */
    public function setVpnProfileName(XFkType $vpnProfileName = null)
    {
        $this->vpnProfileName = $vpnProfileName;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param XFkType $featureControlPolicy
     * @return LCommonPhoneConfig
     */
    public function setFeatureControlPolicy(XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LCommonPhoneConfig
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LCommonPhoneConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
