<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNotificationChangesReq StructType
 * @subpackage Structs
 */
class GetNotificationChangesReq extends APIRequest
{
    /**
     * The registrationId
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $registrationId;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var RNotificationChange
     */
    public $returnedTags;
    /**
     * Constructor method for GetNotificationChangesReq
     * @uses GetNotificationChangesReq::setRegistrationId()
     * @uses GetNotificationChangesReq::setReturnedTags()
     * @param string $registrationId
     * @param RNotificationChange $returnedTags
     */
    public function __construct($registrationId = null, RNotificationChange $returnedTags = null)
    {
        $this
            ->setRegistrationId($registrationId)
            ->setReturnedTags($returnedTags);
    }
    /**
     * Get registrationId value
     * @return string|null
     */
    public function getRegistrationId()
    {
        return $this->registrationId;
    }
    /**
     * Set registrationId value
     * @param string $registrationId
     * @return GetNotificationChangesReq
     */
    public function setRegistrationId($registrationId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($registrationId) && strlen($registrationId) > 32) || (is_array($registrationId) && count($registrationId) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($registrationId) ? strlen($registrationId) : count($registrationId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationId) && !is_string($registrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationId)), __LINE__);
        }
        $this->registrationId = $registrationId;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return RNotificationChange|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param RNotificationChange $returnedTags
     * @return GetNotificationChangesReq
     */
    public function setReturnedTags(RNotificationChange $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetNotificationChangesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
