<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMessageWaitingReq StructType
 * @subpackage Structs
 */
class GetMessageWaitingReq extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The returnedTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var RMessageWaiting
     */
    public $returnedTags;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for GetMessageWaitingReq
     * @uses GetMessageWaitingReq::setPattern()
     * @uses GetMessageWaitingReq::setRoutePartitionName()
     * @uses GetMessageWaitingReq::setUuid()
     * @uses GetMessageWaitingReq::setReturnedTags()
     * @uses GetMessageWaitingReq::setSequence()
     * @param string $pattern
     * @param XFkType $routePartitionName
     * @param string $uuid
     * @param RMessageWaiting $returnedTags
     * @param int $sequence
     */
    public function __construct($pattern = null, XFkType $routePartitionName = null, $uuid = null, RMessageWaiting $returnedTags = null, $sequence = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setUuid($uuid)
            ->setReturnedTags($returnedTags)
            ->setSequence($sequence);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return GetMessageWaitingReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return GetMessageWaitingReq
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return GetMessageWaitingReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get returnedTags value
     * @return RMessageWaiting|null
     */
    public function getReturnedTags()
    {
        return $this->returnedTags;
    }
    /**
     * Set returnedTags value
     * @param RMessageWaiting $returnedTags
     * @return GetMessageWaitingReq
     */
    public function setReturnedTags(RMessageWaiting $returnedTags = null)
    {
        $this->returnedTags = $returnedTags;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return GetMessageWaitingReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetMessageWaitingReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
