<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoNotificationObjectReq StructType
 * @subpackage Structs
 */
class DoNotificationObjectReq extends APIRequest
{
    /**
     * The registrationId
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $registrationId;
    /**
     * The operation
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $operation;
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - maxLength: 255
     * @var string
     */
    public $object;
    /**
     * Constructor method for DoNotificationObjectReq
     * @uses DoNotificationObjectReq::setRegistrationId()
     * @uses DoNotificationObjectReq::setOperation()
     * @uses DoNotificationObjectReq::setObject()
     * @param string $registrationId
     * @param string $operation
     * @param string $object
     */
    public function __construct($registrationId = null, $operation = null, $object = null)
    {
        $this
            ->setRegistrationId($registrationId)
            ->setOperation($operation)
            ->setObject($object);
    }
    /**
     * Get registrationId value
     * @return string|null
     */
    public function getRegistrationId()
    {
        return $this->registrationId;
    }
    /**
     * Set registrationId value
     * @param string $registrationId
     * @return DoNotificationObjectReq
     */
    public function setRegistrationId($registrationId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($registrationId) && strlen($registrationId) > 32) || (is_array($registrationId) && count($registrationId) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($registrationId) ? strlen($registrationId) : count($registrationId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationId) && !is_string($registrationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationId)), __LINE__);
        }
        $this->registrationId = $registrationId;
        return $this;
    }
    /**
     * Get operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->operation;
    }
    /**
     * Set operation value
     * @param string $operation
     * @return DoNotificationObjectReq
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operation) && strlen($operation) > 32) || (is_array($operation) && count($operation) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($operation) ? strlen($operation) : count($operation)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operation)), __LINE__);
        }
        $this->operation = $operation;
        return $this;
    }
    /**
     * Get object value
     * @return string|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return DoNotificationObjectReq
     */
    public function setObject($object = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($object) && strlen($object) > 255) || (is_array($object) && count($object) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($object) ? strlen($object) : count($object)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoNotificationObjectReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
