<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoDeviceResetReq StructType
 * Meta informations extracted from the WSDL
 * - documentation: Performs either a hard or soft reset on the specified device. If resetting an MGCP box, then set isMGCP attribute to true.
 * @subpackage Structs
 */
class DoDeviceResetReq extends APIRequest
{
    /**
     * The deviceName
     * Meta informations extracted from the WSDL
     * - documentation: The name or UUID of the device to performs a reset on. Not nullable.
     * - nillable: false
     * @var XFkType
     */
    public $deviceName;
    /**
     * The isHardReset
     * Meta informations extracted from the WSDL
     * - documentation: True performs a hard reset. False performs a soft reset. Not nullable.
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isHardReset;
    /**
     * The deviceResetType
     * Meta informations extracted from the WSDL
     * - documentation: Not nullable
     * - nillable: false
     * @var string
     */
    public $deviceResetType;
    /**
     * The isMGCP
     * Meta informations extracted from the WSDL
     * - default: false
     * - use: optional
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMGCP;
    /**
     * Constructor method for DoDeviceResetReq
     * @uses DoDeviceResetReq::setDeviceName()
     * @uses DoDeviceResetReq::setIsHardReset()
     * @uses DoDeviceResetReq::setDeviceResetType()
     * @uses DoDeviceResetReq::setIsMGCP()
     * @param XFkType $deviceName
     * @param string $isHardReset
     * @param string $deviceResetType
     * @param string $isMGCP
     */
    public function __construct(XFkType $deviceName = null, $isHardReset = null, $deviceResetType = null, $isMGCP = false)
    {
        $this
            ->setDeviceName($deviceName)
            ->setIsHardReset($isHardReset)
            ->setDeviceResetType($deviceResetType)
            ->setIsMGCP($isMGCP);
    }
    /**
     * Get deviceName value
     * @return XFkType|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param XFkType $deviceName
     * @return DoDeviceResetReq
     */
    public function setDeviceName(XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get isHardReset value
     * @return string|null
     */
    public function getIsHardReset()
    {
        return $this->isHardReset;
    }
    /**
     * Set isHardReset value
     * @param string $isHardReset
     * @return DoDeviceResetReq
     */
    public function setIsHardReset($isHardReset = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isHardReset) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isHardReset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isHardReset, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isHardReset) && !is_string($isHardReset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isHardReset)), __LINE__);
        }
        $this->isHardReset = $isHardReset;
        return $this;
    }
    /**
     * Get deviceResetType value
     * @return string|null
     */
    public function getDeviceResetType()
    {
        return $this->deviceResetType;
    }
    /**
     * Set deviceResetType value
     * @uses XReset::valueIsValid()
     * @uses XReset::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceResetType
     * @return DoDeviceResetReq
     */
    public function setDeviceResetType($deviceResetType = null)
    {
        // validation for constraint: enumeration
        if (!XReset::valueIsValid($deviceResetType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceResetType, implode(', ', XReset::getValidValues())), __LINE__);
        }
        $this->deviceResetType = $deviceResetType;
        return $this;
    }
    /**
     * Get isMGCP value
     * @return string|null
     */
    public function getIsMGCP()
    {
        return $this->isMGCP;
    }
    /**
     * Set isMGCP value
     * @param string $isMGCP
     * @return DoDeviceResetReq
     */
    public function setIsMGCP($isMGCP = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isMGCP) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMGCP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isMGCP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isMGCP) && !is_string($isMGCP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMGCP)), __LINE__);
        }
        $this->isMGCP = $isMGCP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoDeviceResetReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
