<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for callInfoDisplay StructType
 * @subpackage Structs
 */
class CallInfoDisplay extends AbstractStructBase
{
    /**
     * The callerName
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callerName;
    /**
     * The callerNumber
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callerNumber;
    /**
     * The redirectedNumber
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectedNumber;
    /**
     * The dialedNumber
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dialedNumber;
    /**
     * Constructor method for callInfoDisplay
     * @uses CallInfoDisplay::setCallerName()
     * @uses CallInfoDisplay::setCallerNumber()
     * @uses CallInfoDisplay::setRedirectedNumber()
     * @uses CallInfoDisplay::setDialedNumber()
     * @param string $callerName
     * @param string $callerNumber
     * @param string $redirectedNumber
     * @param string $dialedNumber
     */
    public function __construct($callerName = true, $callerNumber = false, $redirectedNumber = false, $dialedNumber = true)
    {
        $this
            ->setCallerName($callerName)
            ->setCallerNumber($callerNumber)
            ->setRedirectedNumber($redirectedNumber)
            ->setDialedNumber($dialedNumber);
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return CallInfoDisplay
     */
    public function setCallerName($callerName = true)
    {
        // validation for constraint: pattern
        if (is_scalar($callerName) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($callerName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerName)), __LINE__);
        }
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callerNumber value
     * @return string|null
     */
    public function getCallerNumber()
    {
        return $this->callerNumber;
    }
    /**
     * Set callerNumber value
     * @param string $callerNumber
     * @return CallInfoDisplay
     */
    public function setCallerNumber($callerNumber = false)
    {
        // validation for constraint: pattern
        if (is_scalar($callerNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($callerNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerNumber) && !is_string($callerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerNumber)), __LINE__);
        }
        $this->callerNumber = $callerNumber;
        return $this;
    }
    /**
     * Get redirectedNumber value
     * @return string|null
     */
    public function getRedirectedNumber()
    {
        return $this->redirectedNumber;
    }
    /**
     * Set redirectedNumber value
     * @param string $redirectedNumber
     * @return CallInfoDisplay
     */
    public function setRedirectedNumber($redirectedNumber = false)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectedNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectedNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectedNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectedNumber) && !is_string($redirectedNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectedNumber)), __LINE__);
        }
        $this->redirectedNumber = $redirectedNumber;
        return $this;
    }
    /**
     * Get dialedNumber value
     * @return string|null
     */
    public function getDialedNumber()
    {
        return $this->dialedNumber;
    }
    /**
     * Set dialedNumber value
     * @param string $dialedNumber
     * @return CallInfoDisplay
     */
    public function setDialedNumber($dialedNumber = true)
    {
        // validation for constraint: pattern
        if (is_scalar($dialedNumber) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dialedNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dialedNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dialedNumber) && !is_string($dialedNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dialedNumber)), __LINE__);
        }
        $this->dialedNumber = $dialedNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return CallInfoDisplay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
