<?php
/**
 * This class stands for XZzkpml EnumType
 * @subpackage Enumerations
 */
class XZzkpml
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Signal only'
     * @return string 'Signal only'
     */
    const VALUE_SIGNAL_ONLY = 'Signal only';
    /**
     * Constant for value 'Dtmf only'
     * @return string 'Dtmf only'
     */
    const VALUE_DTMF_ONLY = 'Dtmf only';
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SIGNAL_ONLY
     * @uses self::VALUE_DTMF_ONLY
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SIGNAL_ONLY,
            self::VALUE_DTMF_ONLY,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
