<?php
/**
 * This class stands for XWebPageSection EnumType
 * @subpackage Enumerations
 */
class XWebPageSection
{
    /**
     * Constant for value 'Required and Frequently Entered Settings'
     * @return string 'Required and Frequently Entered Settings'
     */
    const VALUE_REQUIRED_AND_FREQUENTLY_ENTERED_SETTINGS = 'Required and Frequently Entered Settings';
    /**
     * Constant for value 'Phone Buttons Configuration'
     * @return string 'Phone Buttons Configuration'
     */
    const VALUE_PHONE_BUTTONS_CONFIGURATION = 'Phone Buttons Configuration';
    /**
     * Constant for value 'Device Settings'
     * @return string 'Device Settings'
     */
    const VALUE_DEVICE_SETTINGS = 'Device Settings';
    /**
     * Constant for value 'Device Routing Settings'
     * @return string 'Device Routing Settings'
     */
    const VALUE_DEVICE_ROUTING_SETTINGS = 'Device Routing Settings';
    /**
     * Constant for value 'Phone Settings'
     * @return string 'Phone Settings'
     */
    const VALUE_PHONE_SETTINGS = 'Phone Settings';
    /**
     * Constant for value 'Protocol Settings'
     * @return string 'Protocol Settings'
     */
    const VALUE_PROTOCOL_SETTINGS = 'Protocol Settings';
    /**
     * Constant for value 'IP Phone Services Subscription'
     * @return string 'IP Phone Services Subscription'
     */
    const VALUE_IP_PHONE_SERVICES_SUBSCRIPTION = 'IP Phone Services Subscription';
    /**
     * Constant for value 'Security Settings'
     * @return string 'Security Settings'
     */
    const VALUE_SECURITY_SETTINGS = 'Security Settings';
    /**
     * Constant for value 'Service Configuration Settings'
     * @return string 'Service Configuration Settings'
     */
    const VALUE_SERVICE_CONFIGURATION_SETTINGS = 'Service Configuration Settings';
    /**
     * Constant for value 'Troubleshooting Settings'
     * @return string 'Troubleshooting Settings'
     */
    const VALUE_TROUBLESHOOTING_SETTINGS = 'Troubleshooting Settings';
    /**
     * Constant for value 'Locale Settings'
     * @return string 'Locale Settings'
     */
    const VALUE_LOCALE_SETTINGS = 'Locale Settings';
    /**
     * Constant for value 'Multilevel Precedence Preemption (MLPP) Settings'
     * @return string 'Multilevel Precedence Preemption (MLPP) Settings'
     */
    const VALUE_MULTILEVEL_PRECEDENCE_PREEMPTION_MLPP_SETTINGS = 'Multilevel Precedence Preemption (MLPP) Settings';
    /**
     * Constant for value 'Do Not Disturb (DND) Settings'
     * @return string 'Do Not Disturb (DND) Settings'
     */
    const VALUE_DO_NOT_DISTURB_DND_SETTINGS = 'Do Not Disturb (DND) Settings';
    /**
     * Constant for value 'Automatic Alternate Routing (AAR) Settings'
     * @return string 'Automatic Alternate Routing (AAR) Settings'
     */
    const VALUE_AUTOMATIC_ALTERNATE_ROUTING_AAR_SETTINGS = 'Automatic Alternate Routing (AAR) Settings';
    /**
     * Constant for value 'Busy Lamp Field (BLF) Settings'
     * @return string 'Busy Lamp Field (BLF) Settings'
     */
    const VALUE_BUSY_LAMP_FIELD_BLF_SETTINGS = 'Busy Lamp Field (BLF) Settings';
    /**
     * Constant for value 'Music on Hold Settings'
     * @return string 'Music on Hold Settings'
     */
    const VALUE_MUSIC_ON_HOLD_SETTINGS = 'Music on Hold Settings';
    /**
     * Constant for value 'Location Settings'
     * @return string 'Location Settings'
     */
    const VALUE_LOCATION_SETTINGS = 'Location Settings';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REQUIRED_AND_FREQUENTLY_ENTERED_SETTINGS
     * @uses self::VALUE_PHONE_BUTTONS_CONFIGURATION
     * @uses self::VALUE_DEVICE_SETTINGS
     * @uses self::VALUE_DEVICE_ROUTING_SETTINGS
     * @uses self::VALUE_PHONE_SETTINGS
     * @uses self::VALUE_PROTOCOL_SETTINGS
     * @uses self::VALUE_IP_PHONE_SERVICES_SUBSCRIPTION
     * @uses self::VALUE_SECURITY_SETTINGS
     * @uses self::VALUE_SERVICE_CONFIGURATION_SETTINGS
     * @uses self::VALUE_TROUBLESHOOTING_SETTINGS
     * @uses self::VALUE_LOCALE_SETTINGS
     * @uses self::VALUE_MULTILEVEL_PRECEDENCE_PREEMPTION_MLPP_SETTINGS
     * @uses self::VALUE_DO_NOT_DISTURB_DND_SETTINGS
     * @uses self::VALUE_AUTOMATIC_ALTERNATE_ROUTING_AAR_SETTINGS
     * @uses self::VALUE_BUSY_LAMP_FIELD_BLF_SETTINGS
     * @uses self::VALUE_MUSIC_ON_HOLD_SETTINGS
     * @uses self::VALUE_LOCATION_SETTINGS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REQUIRED_AND_FREQUENTLY_ENTERED_SETTINGS,
            self::VALUE_PHONE_BUTTONS_CONFIGURATION,
            self::VALUE_DEVICE_SETTINGS,
            self::VALUE_DEVICE_ROUTING_SETTINGS,
            self::VALUE_PHONE_SETTINGS,
            self::VALUE_PROTOCOL_SETTINGS,
            self::VALUE_IP_PHONE_SERVICES_SUBSCRIPTION,
            self::VALUE_SECURITY_SETTINGS,
            self::VALUE_SERVICE_CONFIGURATION_SETTINGS,
            self::VALUE_TROUBLESHOOTING_SETTINGS,
            self::VALUE_LOCALE_SETTINGS,
            self::VALUE_MULTILEVEL_PRECEDENCE_PREEMPTION_MLPP_SETTINGS,
            self::VALUE_DO_NOT_DISTURB_DND_SETTINGS,
            self::VALUE_AUTOMATIC_ALTERNATE_ROUTING_AAR_SETTINGS,
            self::VALUE_BUSY_LAMP_FIELD_BLF_SETTINGS,
            self::VALUE_MUSIC_ON_HOLD_SETTINGS,
            self::VALUE_LOCATION_SETTINGS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
