<?php
/**
 * This class stands for XUserNotificationSection EnumType
 * @subpackage Enumerations
 */
class XUserNotificationSection
{
    /**
     * Constant for value 'Information Message'
     * @return string 'Information Message'
     */
    const VALUE_INFORMATION_MESSAGE = 'Information Message';
    /**
     * Constant for value 'Setup Message'
     * @return string 'Setup Message'
     */
    const VALUE_SETUP_MESSAGE = 'Setup Message';
    /**
     * Constant for value 'Feature Message'
     * @return string 'Feature Message'
     */
    const VALUE_FEATURE_MESSAGE = 'Feature Message';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INFORMATION_MESSAGE
     * @uses self::VALUE_SETUP_MESSAGE
     * @uses self::VALUE_FEATURE_MESSAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INFORMATION_MESSAGE,
            self::VALUE_SETUP_MESSAGE,
            self::VALUE_FEATURE_MESSAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
