<?php
/**
 * This class stands for XUserNotificationMessage EnumType
 * @subpackage Enumerations
 */
class XUserNotificationMessage
{
    /**
     * Constant for value 'Select Correct Phone for User'
     * @return string 'Select Correct Phone for User'
     */
    const VALUE_SELECT_CORRECT_PHONE_FOR_USER = 'Select Correct Phone for User';
    /**
     * Constant for value 'Select Correct Line for User'
     * @return string 'Select Correct Line for User'
     */
    const VALUE_SELECT_CORRECT_LINE_FOR_USER = 'Select Correct Line for User';
    /**
     * Constant for value 'Set Description'
     * @return string 'Set Description'
     */
    const VALUE_SET_DESCRIPTION = 'Set Description';
    /**
     * Constant for value 'Reset Password'
     * @return string 'Reset Password'
     */
    const VALUE_RESET_PASSWORD = 'Reset Password';
    /**
     * Constant for value 'Set Click to Call'
     * @return string 'Set Click to Call'
     */
    const VALUE_SET_CLICK_TO_CALL = 'Set Click to Call';
    /**
     * Constant for value 'Set Speed Dial'
     * @return string 'Set Speed Dial'
     */
    const VALUE_SET_SPEED_DIAL = 'Set Speed Dial';
    /**
     * Constant for value 'Subscribe to Phone Service'
     * @return string 'Subscribe to Phone Service'
     */
    const VALUE_SUBSCRIBE_TO_PHONE_SERVICE = 'Subscribe to Phone Service';
    /**
     * Constant for value 'No Service Assigned'
     * @return string 'No Service Assigned'
     */
    const VALUE_NO_SERVICE_ASSIGNED = 'No Service Assigned';
    /**
     * Constant for value 'Set Alternate Number'
     * @return string 'Set Alternate Number'
     */
    const VALUE_SET_ALTERNATE_NUMBER = 'Set Alternate Number';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SELECT_CORRECT_PHONE_FOR_USER
     * @uses self::VALUE_SELECT_CORRECT_LINE_FOR_USER
     * @uses self::VALUE_SET_DESCRIPTION
     * @uses self::VALUE_RESET_PASSWORD
     * @uses self::VALUE_SET_CLICK_TO_CALL
     * @uses self::VALUE_SET_SPEED_DIAL
     * @uses self::VALUE_SUBSCRIBE_TO_PHONE_SERVICE
     * @uses self::VALUE_NO_SERVICE_ASSIGNED
     * @uses self::VALUE_SET_ALTERNATE_NUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SELECT_CORRECT_PHONE_FOR_USER,
            self::VALUE_SELECT_CORRECT_LINE_FOR_USER,
            self::VALUE_SET_DESCRIPTION,
            self::VALUE_RESET_PASSWORD,
            self::VALUE_SET_CLICK_TO_CALL,
            self::VALUE_SET_SPEED_DIAL,
            self::VALUE_SUBSCRIBE_TO_PHONE_SERVICE,
            self::VALUE_NO_SERVICE_ASSIGNED,
            self::VALUE_SET_ALTERNATE_NUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
