<?php
/**
 * This class stands for XUserAgentServerHeaderInfo EnumType
 * @subpackage Enumerations
 */
class XUserAgentServerHeaderInfo
{
    /**
     * Constant for value 'Send Unified CM Version Information as User-Agent Header'
     * @return string 'Send Unified CM Version Information as User-Agent Header'
     */
    const VALUE_SEND_UNIFIED_CM_VERSION_INFORMATION_AS_USER_AGENT_HEADER = 'Send Unified CM Version Information as User-Agent Header';
    /**
     * Constant for value 'Pass Through Received Information as Contact Header
     * Parameters'
     * @return string 'Pass Through Received Information as Contact Header Parameters'
     */
    const VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_CONTACT_HEADER_PARAMETERS = 'Pass Through Received Information as Contact Header Parameters';
    /**
     * Constant for value 'Pass Through Received Information as User-Agent and Server
     * Header'
     * @return string 'Pass Through Received Information as User-Agent and Server Header'
     */
    const VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_USER_AGENT_AND_SERVER_HEADER = 'Pass Through Received Information as User-Agent and Server Header';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SEND_UNIFIED_CM_VERSION_INFORMATION_AS_USER_AGENT_HEADER
     * @uses self::VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_CONTACT_HEADER_PARAMETERS
     * @uses self::VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_USER_AGENT_AND_SERVER_HEADER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SEND_UNIFIED_CM_VERSION_INFORMATION_AS_USER_AGENT_HEADER,
            self::VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_CONTACT_HEADER_PARAMETERS,
            self::VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_USER_AGENT_AND_SERVER_HEADER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
