<?php
/**
 * This class stands for XUCService EnumType
 * @subpackage Enumerations
 */
class XUCService
{
    /**
     * Constant for value 'Voicemail'
     * @return string 'Voicemail'
     */
    const VALUE_VOICEMAIL = 'Voicemail';
    /**
     * Constant for value 'Visual Voicemail'
     * @return string 'Visual Voicemail'
     */
    const VALUE_VISUAL_VOICEMAIL = 'Visual Voicemail';
    /**
     * Constant for value 'Conferencing'
     * @return string 'Conferencing'
     */
    const VALUE_CONFERENCING = 'Conferencing';
    /**
     * Constant for value 'Directory'
     * @return string 'Directory'
     */
    const VALUE_DIRECTORY = 'Directory';
    /**
     * Constant for value 'IM and Presence'
     * @return string 'IM and Presence'
     */
    const VALUE_IM_AND_PRESENCE = 'IM and Presence';
    /**
     * Constant for value 'CTI'
     * @return string 'CTI'
     */
    const VALUE_CTI = 'CTI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VOICEMAIL
     * @uses self::VALUE_VISUAL_VOICEMAIL
     * @uses self::VALUE_CONFERENCING
     * @uses self::VALUE_DIRECTORY
     * @uses self::VALUE_IM_AND_PRESENCE
     * @uses self::VALUE_CTI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOICEMAIL,
            self::VALUE_VISUAL_VOICEMAIL,
            self::VALUE_CONFERENCING,
            self::VALUE_DIRECTORY,
            self::VALUE_IM_AND_PRESENCE,
            self::VALUE_CTI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
