<?php
/**
 * This class stands for XUCProductConnectProtocolMap EnumType
 * @subpackage Enumerations
 */
class XUCProductConnectProtocolMap
{
    /**
     * Constant for value 'Unity using HTTP'
     * @return string 'Unity using HTTP'
     */
    const VALUE_UNITY_USING_HTTP = 'Unity using HTTP';
    /**
     * Constant for value 'Unity using HTTPS'
     * @return string 'Unity using HTTPS'
     */
    const VALUE_UNITY_USING_HTTPS = 'Unity using HTTPS';
    /**
     * Constant for value 'Unity Connection using HTTP'
     * @return string 'Unity Connection using HTTP'
     */
    const VALUE_UNITY_CONNECTION_USING_HTTP = 'Unity Connection using HTTP';
    /**
     * Constant for value 'Unity Connection using HTTPS'
     * @return string 'Unity Connection using HTTPS'
     */
    const VALUE_UNITY_CONNECTION_USING_HTTPS = 'Unity Connection using HTTPS';
    /**
     * Constant for value 'Exchange using TCP'
     * @return string 'Exchange using TCP'
     */
    const VALUE_EXCHANGE_USING_TCP = 'Exchange using TCP';
    /**
     * Constant for value 'Exchange using UDP'
     * @return string 'Exchange using UDP'
     */
    const VALUE_EXCHANGE_USING_UDP = 'Exchange using UDP';
    /**
     * Constant for value 'Exchange using SSL'
     * @return string 'Exchange using SSL'
     */
    const VALUE_EXCHANGE_USING_SSL = 'Exchange using SSL';
    /**
     * Constant for value 'Exchange using TLS'
     * @return string 'Exchange using TLS'
     */
    const VALUE_EXCHANGE_USING_TLS = 'Exchange using TLS';
    /**
     * Constant for value 'MeetingPlace Classic using HTTP'
     * @return string 'MeetingPlace Classic using HTTP'
     */
    const VALUE_MEETING_PLACE_CLASSIC_USING_HTTP = 'MeetingPlace Classic using HTTP';
    /**
     * Constant for value 'MeetingPlace Classic using HTTPS'
     * @return string 'MeetingPlace Classic using HTTPS'
     */
    const VALUE_MEETING_PLACE_CLASSIC_USING_HTTPS = 'MeetingPlace Classic using HTTPS';
    /**
     * Constant for value 'MeetingPlace Express using HTTP'
     * @return string 'MeetingPlace Express using HTTP'
     */
    const VALUE_MEETING_PLACE_EXPRESS_USING_HTTP = 'MeetingPlace Express using HTTP';
    /**
     * Constant for value 'MeetingPlace Express using HTTPS'
     * @return string 'MeetingPlace Express using HTTPS'
     */
    const VALUE_MEETING_PLACE_EXPRESS_USING_HTTPS = 'MeetingPlace Express using HTTPS';
    /**
     * Constant for value 'WebEx (Conferencing) using HTTP'
     * @return string 'WebEx (Conferencing) using HTTP'
     */
    const VALUE_WEB_EX_CONFERENCING_USING_HTTP = 'WebEx (Conferencing) using HTTP';
    /**
     * Constant for value 'WebEx (Conferencing) using HTTPS'
     * @return string 'WebEx (Conferencing) using HTTPS'
     */
    const VALUE_WEB_EX_CONFERENCING_USING_HTTPS = 'WebEx (Conferencing) using HTTPS';
    /**
     * Constant for value 'Directory using TCP'
     * @return string 'Directory using TCP'
     */
    const VALUE_DIRECTORY_USING_TCP = 'Directory using TCP';
    /**
     * Constant for value 'Directory using UDP'
     * @return string 'Directory using UDP'
     */
    const VALUE_DIRECTORY_USING_UDP = 'Directory using UDP';
    /**
     * Constant for value 'Directory using TLS'
     * @return string 'Directory using TLS'
     */
    const VALUE_DIRECTORY_USING_TLS = 'Directory using TLS';
    /**
     * Constant for value 'Unified CM (IM and Presence) (No Protocol)'
     * @return string 'Unified CM (IM and Presence) (No Protocol)'
     */
    const VALUE_UNIFIED_CM_IM_AND_PRESENCE_NO_PROTOCOL = 'Unified CM (IM and Presence) (No Protocol)';
    /**
     * Constant for value 'WebEx (IM and Presence) using XMPP'
     * @return string 'WebEx (IM and Presence) using XMPP'
     */
    const VALUE_WEB_EX_IM_AND_PRESENCE_USING_XMPP = 'WebEx (IM and Presence) using XMPP';
    /**
     * Constant for value 'CTI using TCP'
     * @return string 'CTI using TCP'
     */
    const VALUE_CTI_USING_TCP = 'CTI using TCP';
    /**
     * Constant for value 'Ldap Directory using TCP'
     * @return string 'Ldap Directory using TCP'
     */
    const VALUE_LDAP_DIRECTORY_USING_TCP = 'Ldap Directory using TCP';
    /**
     * Constant for value 'Ldap Directory using SSL'
     * @return string 'Ldap Directory using SSL'
     */
    const VALUE_LDAP_DIRECTORY_USING_SSL = 'Ldap Directory using SSL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNITY_USING_HTTP
     * @uses self::VALUE_UNITY_USING_HTTPS
     * @uses self::VALUE_UNITY_CONNECTION_USING_HTTP
     * @uses self::VALUE_UNITY_CONNECTION_USING_HTTPS
     * @uses self::VALUE_EXCHANGE_USING_TCP
     * @uses self::VALUE_EXCHANGE_USING_UDP
     * @uses self::VALUE_EXCHANGE_USING_SSL
     * @uses self::VALUE_EXCHANGE_USING_TLS
     * @uses self::VALUE_MEETING_PLACE_CLASSIC_USING_HTTP
     * @uses self::VALUE_MEETING_PLACE_CLASSIC_USING_HTTPS
     * @uses self::VALUE_MEETING_PLACE_EXPRESS_USING_HTTP
     * @uses self::VALUE_MEETING_PLACE_EXPRESS_USING_HTTPS
     * @uses self::VALUE_WEB_EX_CONFERENCING_USING_HTTP
     * @uses self::VALUE_WEB_EX_CONFERENCING_USING_HTTPS
     * @uses self::VALUE_DIRECTORY_USING_TCP
     * @uses self::VALUE_DIRECTORY_USING_UDP
     * @uses self::VALUE_DIRECTORY_USING_TLS
     * @uses self::VALUE_UNIFIED_CM_IM_AND_PRESENCE_NO_PROTOCOL
     * @uses self::VALUE_WEB_EX_IM_AND_PRESENCE_USING_XMPP
     * @uses self::VALUE_CTI_USING_TCP
     * @uses self::VALUE_LDAP_DIRECTORY_USING_TCP
     * @uses self::VALUE_LDAP_DIRECTORY_USING_SSL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNITY_USING_HTTP,
            self::VALUE_UNITY_USING_HTTPS,
            self::VALUE_UNITY_CONNECTION_USING_HTTP,
            self::VALUE_UNITY_CONNECTION_USING_HTTPS,
            self::VALUE_EXCHANGE_USING_TCP,
            self::VALUE_EXCHANGE_USING_UDP,
            self::VALUE_EXCHANGE_USING_SSL,
            self::VALUE_EXCHANGE_USING_TLS,
            self::VALUE_MEETING_PLACE_CLASSIC_USING_HTTP,
            self::VALUE_MEETING_PLACE_CLASSIC_USING_HTTPS,
            self::VALUE_MEETING_PLACE_EXPRESS_USING_HTTP,
            self::VALUE_MEETING_PLACE_EXPRESS_USING_HTTPS,
            self::VALUE_WEB_EX_CONFERENCING_USING_HTTP,
            self::VALUE_WEB_EX_CONFERENCING_USING_HTTPS,
            self::VALUE_DIRECTORY_USING_TCP,
            self::VALUE_DIRECTORY_USING_UDP,
            self::VALUE_DIRECTORY_USING_TLS,
            self::VALUE_UNIFIED_CM_IM_AND_PRESENCE_NO_PROTOCOL,
            self::VALUE_WEB_EX_IM_AND_PRESENCE_USING_XMPP,
            self::VALUE_CTI_USING_TCP,
            self::VALUE_LDAP_DIRECTORY_USING_TCP,
            self::VALUE_LDAP_DIRECTORY_USING_SSL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
