<?php
/**
 * This class stands for XUCProductAppServerMap EnumType
 * @subpackage Enumerations
 */
class XUCProductAppServerMap
{
    /**
     * Constant for value 'Unity'
     * @return string 'Unity'
     */
    const VALUE_UNITY = 'Unity';
    /**
     * Constant for value 'Unity Connection'
     * @return string 'Unity Connection'
     */
    const VALUE_UNITY_CONNECTION = 'Unity Connection';
    /**
     * Constant for value 'IM and Presence'
     * @return string 'IM and Presence'
     */
    const VALUE_IM_AND_PRESENCE = 'IM and Presence';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNITY
     * @uses self::VALUE_UNITY_CONNECTION
     * @uses self::VALUE_IM_AND_PRESENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNITY,
            self::VALUE_UNITY_CONNECTION,
            self::VALUE_IM_AND_PRESENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
