<?php
/**
 * This class stands for XSecurityPolicy EnumType
 * @subpackage Enumerations
 */
class XSecurityPolicy
{
    /**
     * Constant for value 'SIP Trunk'
     * @return string 'SIP Trunk'
     */
    const VALUE_SIP_TRUNK = 'SIP Trunk';
    /**
     * Constant for value 'Phone'
     * @return string 'Phone'
     */
    const VALUE_PHONE = 'Phone';
    /**
     * Constant for value 'VM Port'
     * @return string 'VM Port'
     */
    const VALUE_VM_PORT = 'VM Port';
    /**
     * Constant for value 'Conference Bridge'
     * @return string 'Conference Bridge'
     */
    const VALUE_CONFERENCE_BRIDGE = 'Conference Bridge';
    /**
     * Constant for value 'CUMA Server'
     * @return string 'CUMA Server'
     */
    const VALUE_CUMA_SERVER = 'CUMA Server';
    /**
     * Constant for value 'Telepresence MCU'
     * @return string 'Telepresence MCU'
     */
    const VALUE_TELEPRESENCE_MCU = 'Telepresence MCU';
    /**
     * Constant for value 'Model Independent'
     * @return string 'Model Independent'
     */
    const VALUE_MODEL_INDEPENDENT = 'Model Independent';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SIP_TRUNK
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_VM_PORT
     * @uses self::VALUE_CONFERENCE_BRIDGE
     * @uses self::VALUE_CUMA_SERVER
     * @uses self::VALUE_TELEPRESENCE_MCU
     * @uses self::VALUE_MODEL_INDEPENDENT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SIP_TRUNK,
            self::VALUE_PHONE,
            self::VALUE_VM_PORT,
            self::VALUE_CONFERENCE_BRIDGE,
            self::VALUE_CUMA_SERVER,
            self::VALUE_TELEPRESENCE_MCU,
            self::VALUE_MODEL_INDEPENDENT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
