<?php
/**
 * This class stands for XResourceAction EnumType
 * @subpackage Enumerations
 */
class XResourceAction
{
    /**
     * Constant for value 'read'
     * @return string 'read'
     */
    const VALUE_READ = 'read';
    /**
     * Constant for value 'update'
     * @return string 'update'
     */
    const VALUE_UPDATE = 'update';
    /**
     * Constant for value 'enabled'
     * @return string 'enabled'
     */
    const VALUE_ENABLED = 'enabled';
    /**
     * Constant for value 'allow modification'
     * @return string 'allow modification'
     */
    const VALUE_ALLOW_MODIFICATION = 'allow modification';
    /**
     * Constant for value 'allow retrieval'
     * @return string 'allow retrieval'
     */
    const VALUE_ALLOW_RETRIEVAL = 'allow retrieval';
    /**
     * Constant for value 'allow control of all devices'
     * @return string 'allow control of all devices'
     */
    const VALUE_ALLOW_CONTROL_OF_ALL_DEVICES = 'allow control of all devices';
    /**
     * Constant for value 'Allow to use API'
     * @return string 'Allow to use API'
     */
    const VALUE_ALLOW_TO_USE_API = 'Allow to use API';
    /**
     * Constant for value 'allow'
     * @return string 'allow'
     */
    const VALUE_ALLOW = 'allow';
    /**
     * Constant for value 'enable CTI security'
     * @return string 'enable CTI security'
     */
    const VALUE_ENABLE_CTI_SECURITY = 'enable CTI security';
    /**
     * Constant for value 'enable CTI SRTP key distribution'
     * @return string 'enable CTI SRTP key distribution'
     */
    const VALUE_ENABLE_CTI_SRTP_KEY_DISTRIBUTION = 'enable CTI SRTP key distribution';
    /**
     * Constant for value 'allow monitoring'
     * @return string 'allow monitoring'
     */
    const VALUE_ALLOW_MONITORING = 'allow monitoring';
    /**
     * Constant for value 'allow recording'
     * @return string 'allow recording'
     */
    const VALUE_ALLOW_RECORDING = 'allow recording';
    /**
     * Constant for value 'Allow Control'
     * @return string 'Allow Control'
     */
    const VALUE_ALLOW_CONTROL = 'Allow Control';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_READ
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_ENABLED
     * @uses self::VALUE_ALLOW_MODIFICATION
     * @uses self::VALUE_ALLOW_RETRIEVAL
     * @uses self::VALUE_ALLOW_CONTROL_OF_ALL_DEVICES
     * @uses self::VALUE_ALLOW_TO_USE_API
     * @uses self::VALUE_ALLOW
     * @uses self::VALUE_ENABLE_CTI_SECURITY
     * @uses self::VALUE_ENABLE_CTI_SRTP_KEY_DISTRIBUTION
     * @uses self::VALUE_ALLOW_MONITORING
     * @uses self::VALUE_ALLOW_RECORDING
     * @uses self::VALUE_ALLOW_CONTROL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_READ,
            self::VALUE_UPDATE,
            self::VALUE_ENABLED,
            self::VALUE_ALLOW_MODIFICATION,
            self::VALUE_ALLOW_RETRIEVAL,
            self::VALUE_ALLOW_CONTROL_OF_ALL_DEVICES,
            self::VALUE_ALLOW_TO_USE_API,
            self::VALUE_ALLOW,
            self::VALUE_ENABLE_CTI_SECURITY,
            self::VALUE_ENABLE_CTI_SRTP_KEY_DISTRIBUTION,
            self::VALUE_ALLOW_MONITORING,
            self::VALUE_ALLOW_RECORDING,
            self::VALUE_ALLOW_CONTROL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
